/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.couchbase.connector.cluster.consul.ConsulResourceWatcher;
import com.couchbase.connector.cluster.consul.ReactorHelper;
import com.couchbase.consul.ConsulOps;
import com.couchbase.consul.KvReadResult;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import reactor.core.publisher.Flux;

public class ConsulDocumentWatcher {
    private final ConsulOps consul;
    private final ConsulResourceWatcher resourceWatcher;

    public ConsulDocumentWatcher(ConsulOps consul) {
        this(consul, Duration.ofMinutes(5L));
    }

    private ConsulDocumentWatcher(ConsulOps consul, Duration pollingInterval) {
        this.consul = Objects.requireNonNull(consul);
        this.resourceWatcher = new ConsulResourceWatcher().withPollingInterval(pollingInterval);
    }

    public ConsulDocumentWatcher withPollingInterval(Duration pollingInterval) {
        return new ConsulDocumentWatcher(this.consul, pollingInterval);
    }

    public Optional<String> awaitCondition(String key, Predicate<Optional<String>> valueCondition) throws InterruptedException {
        return ReactorHelper.await(this.watch(key), valueCondition);
    }

    public <T> Optional<T> awaitCondition(String key, Function<String, T> valueMapper, Predicate<Optional<T>> condition) throws InterruptedException {
        return ReactorHelper.await(this.watch(key).map(s -> s.map(valueMapper)), condition);
    }

    public <T> Optional<T> awaitCondition(String key, Function<String, T> valueMapper, Predicate<Optional<T>> condition, Duration timeout) throws InterruptedException, TimeoutException {
        return ReactorHelper.await(this.watch(key).map(s -> s.map(valueMapper)), condition, timeout);
    }

    public void awaitAbsence(String key) throws InterruptedException {
        this.awaitCondition(key, Optional::isEmpty);
    }

    public Optional<String> awaitValueChange(String key, String valueBeforeChange) throws InterruptedException {
        return this.awaitCondition(key, doc -> !doc.equals(Optional.ofNullable(valueBeforeChange)));
    }

    public Flux<Optional<String>> watch(String key) {
        Objects.requireNonNull(key);
        return this.resourceWatcher.watch((Map<String, Object> opts) -> this.consul.kv().readOneKey(key, (Map<String, ?>)opts)).map(it -> ((Optional)it.body()).map(KvReadResult::valueAsString)).distinctUntilChanged();
    }
}

