/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.cluster.consul.ConsulResourceWatcher;
import com.couchbase.connector.cluster.consul.ReactorHelper;
import com.couchbase.connector.elasticsearch.io.BackoffPolicy;
import com.couchbase.connector.elasticsearch.io.BackoffPolicyBuilder;
import com.couchbase.consul.ConsulHttpClient;
import com.couchbase.consul.ConsulOps;
import com.couchbase.consul.ConsulResponse;
import com.couchbase.consul.KvReadResult;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ConsulHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulHelper.class);
    private static final String missingDocumentValue = "";

    private ConsulHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static boolean unlockAndDelete(ConsulHttpClient httpClient, String key, String sessionId) {
        List<Map<String, Map<String, String>>> transaction = List.of(Map.of("KV", Map.of("Verb", "unlock", "Key", key, "Session", sessionId)), Map.of("KV", Map.of("Verb", "delete", "Key", key)));
        ConsulResponse<ObjectNode> response = ReactorHelper.blockSingle(httpClient.put("/txn", new String[0]).bodyJson(transaction).buildWithResponseType(ObjectNode.class));
        if (response.httpStatusCode() == 409) {
            return false;
        }
        response.requireSuccess();
        return true;
    }

    public static long requireModifyIndex(ConsulResponse<Optional<KvReadResult>> response) {
        return response.body().map(KvReadResult::modifyIndex).orElseThrow(() -> new RuntimeException("KV read response missing index"));
    }

    public static void atomicUpdate(ConsulOps.KvOps kv, String key, Function<String, String> mutator) throws IOException {
        Duration timeout = Duration.ofSeconds(15L);
        BackoffPolicy backoffPolicy = BackoffPolicyBuilder.truncatedExponentialBackoff(Duration.ofMillis(10L), Duration.ofSeconds(1L)).fullJitter().timeout(timeout).build();
        Iterator waitIntervals = backoffPolicy.iterator();
        int attempt = 1;
        while (true) {
            ConsulResponse<Optional<KvReadResult>> r;
            if ((r = ReactorHelper.blockSingle(kv.readOneKey(key))).body().isEmpty()) {
                throw new IOException("Can't update non-existent document: " + key);
            }
            long index = ConsulHelper.requireModifyIndex(r);
            String oldValue = r.body().get().valueAsString();
            String newValue = mutator.apply(oldValue);
            if (Objects.equals(newValue, oldValue)) {
                LOGGER.debug("Atomic update of key {} would be a no-op; skipping!", (Object)key);
                return;
            }
            boolean success = ReactorHelper.blockSingle(kv.upsertKey(key, newValue, Map.of("cas", index))).body();
            if (success) {
                LOGGER.debug("Atomic update of key {} completed successfully", (Object)key);
                return;
            }
            if (!waitIntervals.hasNext()) {
                throw new RuntimeException("Atomic update of key '" + key + "' could not complete after " + attempt + " attempts within " + String.valueOf(Duration.ofMinutes(1L)));
            }
            Duration retryDelay = (Duration)waitIntervals.next();
            LOGGER.debug("Retrying atomic update of key {} in {} (attempt {})", new Object[]{key, retryDelay, ++attempt});
            try {
                TimeUnit.MILLISECONDS.sleep(retryDelay.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    public static ConsulResponse<Optional<KvReadResult>> getWithRetry(ConsulOps.KvOps kv, String key, BackoffPolicy backoffPolicy) throws TimeoutException {
        Iterator retryDelays = backoffPolicy.iterator();
        while (true) {
            ConsulResponse<Optional<KvReadResult>> response;
            if ((response = ReactorHelper.blockSingle(kv.readOneKey(key))).body().isPresent()) {
                return response;
            }
            try {
                if (!retryDelays.hasNext()) break;
                Duration retryDelay = (Duration)retryDelays.next();
                LOGGER.debug("Document does not exist; sleeping for {} and then trying again to get {}", (Object)retryDelay, (Object)key);
                TimeUnit.MILLISECONDS.sleep(retryDelay.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        throw new TimeoutException("getWithRetry timed out for key " + key);
    }

    public static void atomicUpdate(ConsulOps.KvOps kv, String key, ConsulResponse<Optional<KvReadResult>> initialResponse, Function<String, String> mutator) throws IOException {
        LOGGER.debug("Updating key {}", (Object)key);
        String oldValue = initialResponse.body().map(KvReadResult::valueAsString).orElse(missingDocumentValue);
        String newValue = mutator.apply(oldValue);
        if (Objects.equals(newValue, oldValue)) {
            return;
        }
        long index = ConsulHelper.requireModifyIndex(initialResponse);
        boolean success = ReactorHelper.blockSingle(kv.upsertKey(key, newValue, Map.of("cas", index))).body();
        if (!success) {
            LOGGER.debug("Failed to put new document (optimistic locking failure?); reloading and retrying");
            ConsulHelper.atomicUpdate(kv, key, mutator);
        }
    }

    public static ConsulResponse<Optional<KvReadResult>> awaitChange(ConsulOps.KvOps kv, String key, long index) {
        ConsulResponse<Optional<KvReadResult>> response;
        while (true) {
            if ((response = ReactorHelper.blockSingle(kv.readOneKey(key, Map.of("index", index, "wait", "5m")))).body().isEmpty()) {
                LOGGER.debug("Document does not exist: {}", (Object)key);
                return response;
            }
            long responseIndex = ConsulHelper.requireModifyIndex(response);
            if (responseIndex != index) break;
            LOGGER.debug("Long poll timed out, polling again for {}", (Object)key);
        }
        return response;
    }

    public static Flux<ImmutableSet<String>> watchServiceHealth(ConsulOps consul, String serviceName) {
        Flux flux = new ConsulResourceWatcher().watch(opts -> {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>((Map<String, Boolean>)opts);
            options.put("passing", true);
            return consul.health().health(serviceName, options);
        }).map(it -> it.requireSuccess().map(arrayNode -> ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)arrayNode, serviceNode -> ConsulContext.formatEndpointId(Objects.requireNonNull(serviceNode.path("Node").path("Node").textValue(), "missing Node.Node"), Objects.requireNonNull(serviceNode.path("Node").path("Address").textValue(), "missing Node.Address"), Objects.requireNonNull(serviceNode.path("Service").path("ID").asText(), "missing Service.ID")))))).map(ConsulResponse::body).distinctUntilChanged().doFinally(signal -> LOGGER.info("Stopping health watch for service {}; reason: {}", (Object)serviceName, signal));
        return ReactorHelper.logOnChange(flux, "Service health", LOGGER);
    }

    public static Flux<ImmutableSet<String>> watchServiceHealth(ConsulOps consul, String serviceName, Duration quietPeriod) {
        return ConsulHelper.watchServiceHealth(consul, serviceName).doOnNext(set -> LOGGER.info("Waiting {} for service health to stabilize before rebalancing.", (Object)quietPeriod)).sampleTimeout(s -> Mono.delay((Duration)quietPeriod)).distinctUntilChanged().doOnNext(set -> LOGGER.info("Service health stabilized; no changes in last {}.", (Object)quietPeriod));
    }
}

