/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.couchbase.consul.ConsulResponse;
import com.google.common.primitives.Longs;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ConsulResourceWatcher {
    private static final Logger log = LoggerFactory.getLogger(ConsulResourceWatcher.class);
    private final String wait;

    public ConsulResourceWatcher() {
        this(Duration.ofMinutes(5L));
    }

    private ConsulResourceWatcher(Duration pollingInterval) {
        long requestedPollingIntervalSeconds = TimeUnit.MILLISECONDS.toSeconds(pollingInterval.toMillis());
        this.wait = Longs.constrainToRange((long)requestedPollingIntervalSeconds, (long)1L, (long)TimeUnit.MINUTES.toSeconds(5L)) + "s";
    }

    public ConsulResourceWatcher withPollingInterval(Duration pollingInterval) {
        return new ConsulResourceWatcher(pollingInterval);
    }

    public <T> Flux<ConsulResponse<T>> watch(Function<Map<String, Object>, Mono<ConsulResponse<T>>> queryParametersToRequest) {
        Objects.requireNonNull(queryParametersToRequest);
        return Flux.defer(() -> {
            AtomicLong prevIndex = new AtomicLong();
            return ((Mono)queryParametersToRequest.apply(Map.of())).expand(item -> {
                long index = item.index().orElse(0L);
                if (index < 1L) {
                    log.warn("Consul resource index was <= 0; this is probably a bug in Consul. Recovering by assuming an index of 1.");
                    index = 1L;
                } else if (index < prevIndex.get()) {
                    log.debug("Consul resource index went backwards; resetting to 0.");
                    index = 0L;
                }
                prevIndex.set(index);
                Mono expansion = (Mono)queryParametersToRequest.apply(Map.of("index", index, "wait", this.wait));
                return item.httpStatusCode() == 404 ? Mono.delay((Duration)ConsulResourceWatcher.withFullJitter(Duration.ofSeconds(1L))).then(expansion) : expansion;
            }).onBackpressureLatest();
        });
    }

    private static Duration withFullJitter(Duration d) {
        return Duration.ofMillis((long)(Math.random() * (double)d.toMillis()));
    }
}

