/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.BooleanNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.dcp.core.utils.DefaultObjectMapper;
import com.couchbase.connector.cluster.consul.ConsulDocumentWatcher;
import com.couchbase.connector.cluster.consul.ReactorHelper;
import com.couchbase.connector.cluster.consul.TimeoutEnforcer;
import com.couchbase.connector.cluster.consul.WorkerService;
import com.couchbase.connector.cluster.consul.rpc.Broadcaster;
import com.couchbase.connector.cluster.consul.rpc.RpcEndpoint;
import com.couchbase.connector.cluster.consul.rpc.RpcResult;
import com.couchbase.consul.ConsulOps;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentKeys {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentKeys.class);
    private static final Duration DEFAULT_ENDPOINT_TIMEOUT = Duration.ofSeconds(15L);
    private final String serviceName;
    private final ConsulOps consul;
    private final ConsulDocumentWatcher watcher;

    public DocumentKeys(ConsulOps consul, ConsulDocumentWatcher watcher, String serviceName) {
        this.consul = Objects.requireNonNull(consul);
        this.serviceName = Objects.requireNonNull(serviceName);
        this.watcher = Objects.requireNonNull(watcher);
    }

    public String root() {
        return "couchbase/cbes/";
    }

    public String config() {
        return this.serviceKey("config");
    }

    public String control() {
        return this.serviceKey("control");
    }

    public String leader() {
        return this.serviceKey("leader");
    }

    private String serviceKey(String suffix) {
        return this.root() + this.serviceName + "/" + suffix;
    }

    public String rpcEndpoint(String endpointId) {
        return this.rpcEndpointKeyPrefix() + Objects.requireNonNull(endpointId);
    }

    private String rpcEndpointKeyPrefix() {
        return this.serviceKey("rpc/");
    }

    private List<String> listKeys(String prefix) {
        return ReactorHelper.blockSingle(this.consul.kv().listKeys(prefix, Map.of())).body();
    }

    public List<String> configuredGroups() {
        String configSuffix = "/config";
        return this.listKeys(this.root()).stream().filter(s -> s.endsWith("/config")).map(s -> StringUtils.removeStart((String)s, (String)this.root())).map(s -> StringUtils.removeEnd((String)s, (String)"/config")).collect(Collectors.toList());
    }

    public List<RpcEndpoint> listRpcEndpoints(Duration endpointTimeout) {
        Objects.requireNonNull(endpointTimeout);
        return this.listKeys(this.rpcEndpointKeyPrefix()).stream().map(endpointKey -> new RpcEndpoint(this.consul.kv(), this.watcher, (String)endpointKey, endpointTimeout)).collect(Collectors.toList());
    }

    public List<RpcEndpoint> listRpcEndpoints() {
        return this.listRpcEndpoints(DEFAULT_ENDPOINT_TIMEOUT);
    }

    public Optional<RpcEndpoint> leaderEndpoint() {
        String endpointId = ReactorHelper.blockSingle(this.consul.kv().readOneKeyAsString(this.leader())).orElse(null);
        return endpointId == null ? Optional.empty() : Optional.of(new RpcEndpoint(this.consul.kv(), this.watcher, this.rpcEndpoint(endpointId), DEFAULT_ENDPOINT_TIMEOUT));
    }

    public boolean pause() throws TimeoutException, IOException {
        ObjectNode control = this.readControlDocument();
        boolean alreadyPaused = control.path("paused").asBoolean(false);
        if (!alreadyPaused) {
            control.set("paused", (JsonNode)BooleanNode.valueOf((boolean)true));
            this.upsertControlDocument(control);
        }
        this.waitForClusterToQuiesce(Duration.ofSeconds(30L));
        return alreadyPaused;
    }

    private void waitForClusterToQuiesce(Duration timeout) throws TimeoutException {
        TimeoutEnforcer timeoutEnforcer = new TimeoutEnforcer("Waiting for cluster to quiesce", timeout);
        try (Broadcaster broadcaster = new Broadcaster();){
            while (true) {
                List<RpcEndpoint> allEndpoints = this.listRpcEndpoints();
                Map<RpcEndpoint, RpcResult<Boolean>> results = broadcaster.broadcast("stopped?", allEndpoints, WorkerService.class, WorkerService::stopped);
                boolean stopped = true;
                for (Map.Entry<RpcEndpoint, RpcResult<Boolean>> e : results.entrySet()) {
                    if (e.getValue().isFailed()) {
                        LOGGER.warn("Status request failed for endpoint " + String.valueOf(e.getKey()));
                        stopped = false;
                        continue;
                    }
                    if (e.getValue().get().booleanValue()) continue;
                    LOGGER.warn("Endpoint is still working: " + String.valueOf(e.getKey()));
                    stopped = false;
                }
                if (stopped) {
                    return;
                }
                timeoutEnforcer.throwIfExpired();
                LOGGER.info("Retrying in just a moment...");
                TimeUnit.SECONDS.sleep(2L);
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            Throwables.propagateIfPossible((Throwable)e, TimeoutException.class);
            throw new RuntimeException(e);
        }
    }

    private ObjectNode readControlDocument() throws IOException {
        Optional<String> s = ReactorHelper.blockSingle(this.consul.kv().readOneKeyAsString(this.control()));
        return (ObjectNode)DefaultObjectMapper.readTree((String)ReactorHelper.blockSingle(this.consul.kv().readOneKeyAsString(this.control())).orElse("{}"));
    }

    private void upsertControlDocument(Object value) throws IOException {
        String json = DefaultObjectMapper.writeValueAsString((Object)value);
        boolean success = ReactorHelper.blockSingle(this.consul.kv().upsertKey(this.control(), json)).body();
        if (!success) {
            throw new IOException("Failed to update control document: " + this.control());
        }
    }

    public void resume() throws IOException {
        ObjectNode control = this.readControlDocument();
        boolean wasPaused = control.path("paused").asBoolean(false);
        if (wasPaused) {
            control.set("paused", (JsonNode)BooleanNode.valueOf((boolean)false));
            this.upsertControlDocument(control);
        }
    }
}

