/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.couchbase.connector.cluster.consul.AbstractLongPollTask;
import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.cluster.consul.LeaderController;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectionTask
extends AbstractLongPollTask<LeaderElectionTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderElectionTask.class);
    private final String candidateUuid;
    private final Consumer<Throwable> fatalErrorConsumer;
    private final LeaderController leaderController;

    public LeaderElectionTask(ConsulContext ctx, String sessionId, String endpointId, Consumer<Throwable> fatalErrorConsumer, LeaderController leaderController) {
        super(ctx, "leader-election-", sessionId);
        this.candidateUuid = Objects.requireNonNull(endpointId);
        this.fatalErrorConsumer = Objects.requireNonNull(fatalErrorConsumer);
        this.leaderController = Objects.requireNonNull(leaderController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun(ConsulContext ctx, String sessionId) {
        String leaderKey = ctx.keys().leader();
        LOGGER.info("Leader key: {}", (Object)leaderKey);
        try {
            while (!this.closed()) {
                LOGGER.info("Racing to become new leader.");
                boolean acquired = ctx.acquireLock(leaderKey, this.candidateUuid, sessionId);
                if (acquired) {
                    LOGGER.info("Won the leader election! {}", (Object)this.candidateUuid);
                    this.leaderController.startLeading();
                    Optional<String> newLeader = ctx.documentWatcher().awaitValueChange(leaderKey, this.candidateUuid);
                    LOGGER.info("No longer the leader; new leader is {}", newLeader);
                    this.leaderController.stopLeading();
                    continue;
                }
                LOGGER.info("Not the leader");
                TimeUnit.SECONDS.sleep(1L);
                ctx.documentWatcher().awaitAbsence(leaderKey);
            }
        }
        catch (Throwable t) {
            if (this.closed()) {
                LOGGER.debug("Caught exception in leader election loop after closing. Don't panic; this is expected.", t);
            } else {
                this.fatalErrorConsumer.accept(t);
            }
        }
        finally {
            try {
                this.leaderController.stopLeading();
                ctx.runCleanup(() -> ctx.unlockAndDelete(leaderKey, sessionId));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to abdicate", (Throwable)e);
            }
            LOGGER.info("Exiting leader election thread for session {}", (Object)sessionId);
        }
    }
}

