/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.InterruptedIOException;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class ReactorHelper {
    private ReactorHelper() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Closeable asCloseable(Disposable d) {
        return () -> ((Disposable)d).dispose();
    }

    public static <T> T blockSingle(Mono<T> mono) {
        return (T)mono.single().block();
    }

    public static <T> T blockSingle(Mono<T> mono, Duration timeout) {
        return (T)mono.single().block(timeout);
    }

    public static <T> T await(Flux<T> flux, Predicate<? super T> condition) throws InterruptedException {
        try {
            return (T)flux.filter(condition).blockFirst();
        }
        catch (RuntimeException e) {
            ReactorHelper.propagateIfInterrupted(e);
            throw e;
        }
    }

    public static <T> T await(Flux<T> flux, Predicate<? super T> condition, Duration timeout) throws InterruptedException, TimeoutException {
        try {
            return (T)flux.filter(condition).timeout(timeout).blockFirst();
        }
        catch (RuntimeException e) {
            ReactorHelper.propagateIfInterrupted(e);
            ReactorHelper.propagateIfTimeout(e);
            throw e;
        }
    }

    private static void propagateIfInterrupted(RuntimeException e) throws InterruptedException {
        Throwables.propagateIfPossible((Throwable)e.getCause(), InterruptedException.class);
        if (e.getCause() instanceof InterruptedIOException) {
            throw ReactorHelper.addSuppressedCause(new InterruptedException(e.getMessage()), e);
        }
    }

    private static void propagateIfTimeout(RuntimeException e) throws TimeoutException {
        Throwables.propagateIfPossible((Throwable)e.getCause(), TimeoutException.class);
    }

    private static <T extends Throwable> T addSuppressedCause(T exception, Throwable cause) {
        exception.addSuppressed(cause);
        return exception;
    }

    public static <T> Mono<T> toMono(Supplier<CompletableFuture<T>> supplier) {
        return Mono.defer(() -> {
            CompletableFuture future = (CompletableFuture)supplier.get();
            return Mono.fromFuture((CompletableFuture)future).doFinally(signal -> {
                if (signal == SignalType.CANCEL) {
                    future.cancel(true);
                }
            }).onErrorMap(t -> t instanceof CompletionException ? t.getCause() : t);
        });
    }

    public static <E, T extends Set<E>> Flux<T> logOnChange(Flux<T> flux, String description, Logger log) {
        return Flux.defer(() -> {
            AtomicReference<ImmutableSet> prev = new AtomicReference<ImmutableSet>(ImmutableSet.of());
            return flux.doOnNext(set -> {
                if (log.isInfoEnabled() && !set.equals(prev.get())) {
                    Sets.SetView joiningNodes = Sets.difference((Set)set, (Set)((Set)prev.get()));
                    Sets.SetView leavingNodes = Sets.difference((Set)((Set)prev.get()), (Set)set);
                    prev.set((ImmutableSet)set);
                    log.info("{} changed; Added: {} Removed: {} Current: {}", new Object[]{description, joiningNodes, leavingNodes, set});
                }
            });
        });
    }
}

