/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.couchbase.connector.cluster.consul.ConsulContext;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTask
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionTask.class);
    private final ConsulContext ctx;
    private final String sessionId;
    private final Runnable runWhenHealthCheckPassed;
    private final Consumer<Throwable> fatalErrorConsumer;
    private volatile boolean shouldPassHealthCheck = true;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private volatile boolean started = false;
    private static final Duration HEALTH_CHECK_INTERVAL = Duration.ofSeconds(15L);

    public SessionTask(ConsulContext consulContext, Runnable runWhenHealthCheckPassed, Consumer<Throwable> fatalErrorConsumer) {
        this.ctx = Objects.requireNonNull(consulContext);
        this.runWhenHealthCheckPassed = Objects.requireNonNull(runWhenHealthCheckPassed);
        this.fatalErrorConsumer = Objects.requireNonNull(fatalErrorConsumer);
        try {
            Duration ttl = HEALTH_CHECK_INTERVAL.multipliedBy(2L);
            this.ctx.register(ttl);
            this.passHealthCheck();
            this.sessionId = this.ctx.createSession();
            LOGGER.info("Registered service {} and started session {}", (Object)this.ctx.serviceId(), (Object)this.sessionId);
        }
        catch (Throwable t) {
            fatalErrorConsumer.accept(t);
            throw t;
        }
    }

    public SessionTask start() {
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        this.started = true;
        int delay = Math.toIntExact(HEALTH_CHECK_INTERVAL.toMillis());
        this.executorService.scheduleWithFixedDelay(this::passHealthCheck, delay, delay, TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public synchronized void close() throws Exception {
        LOGGER.info("Stopping refresh task for session {}", (Object)this.sessionId);
        this.shouldPassHealthCheck = false;
        this.executorService.shutdownNow();
        Duration shutdownTimeout = Duration.ofSeconds(30L);
        if (!Uninterruptibles.awaitTerminationUninterruptibly((ExecutorService)this.executorService, (Duration)shutdownTimeout)) {
            LOGGER.warn("Consul health check executor for session {} failed to shut down within {}.", (Object)this.sessionId, (Object)shutdownTimeout);
        }
    }

    public synchronized void passHealthCheck() {
        if (!this.shouldPassHealthCheck) {
            throw new RuntimeException("Stopping recurring health check task.");
        }
        try {
            this.ctx.passHealthCheck();
            try {
                this.runWhenHealthCheckPassed.run();
            }
            catch (Throwable t) {
                LOGGER.error("Callback failed for passed health check", t);
            }
            LOGGER.debug("Passed health check.");
        }
        catch (Throwable t) {
            this.fatalErrorConsumer.accept(new RuntimeException("Failed to tell Consul agent we passed health check.", t));
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    public String sessionId() {
        return this.sessionId;
    }
}

