/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class TimeoutEnforcer {
    private final long startNanos = System.nanoTime();
    private final long timeoutNanos;
    private final String description;

    private TimeoutEnforcer(String description, long timeoutNanos) {
        Preconditions.checkArgument((timeoutNanos >= 0L ? 1 : 0) != 0, (Object)"timeout must be positive");
        this.timeoutNanos = timeoutNanos;
        this.description = Objects.requireNonNull(description);
    }

    public TimeoutEnforcer(String description, Duration timeout) {
        this(description, TimeoutEnforcer.toNanos(timeout, Long.MAX_VALUE));
    }

    public long remaining(TimeUnit timeUnit) throws TimeoutException {
        long elapsed = System.nanoTime() - this.startNanos;
        long nanosLeft = this.timeoutNanos - elapsed;
        if (nanosLeft <= 0L) {
            throw new TimeoutException(this.description + " timed out after " + this.timeoutNanos + "ns");
        }
        return TimeoutEnforcer.convertRoundUp(nanosLeft, TimeUnit.NANOSECONDS, timeUnit);
    }

    public void throwIfExpired() throws TimeoutException {
        this.remaining(TimeUnit.SECONDS);
    }

    public void throwIfExpiredUnchecked() {
        try {
            this.remaining(TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private static long convertRoundUp(long sourceDuration, TimeUnit sourceUnit, TimeUnit destUnit) {
        Preconditions.checkArgument((sourceDuration >= 0L ? 1 : 0) != 0, (Object)"Duration must be non-negative");
        long nanos = sourceUnit.toNanos(sourceDuration);
        if ((nanos += destUnit.toNanos(1L) - 1L) < 0L) {
            nanos = Long.MAX_VALUE;
        }
        return destUnit.convert(nanos, TimeUnit.NANOSECONDS);
    }

    private static long toNanos(Duration d) {
        try {
            return d.toNanos();
        }
        catch (ArithmeticException e) {
            return d.isNegative() ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
    }

    private static long toNanos(Duration d, long defaultValue) {
        return d == null ? defaultValue : TimeoutEnforcer.toNanos(d);
    }
}

