/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.couchbase.connector.cluster.Membership;
import com.couchbase.connector.elasticsearch.Metrics;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.therapi.core.annotation.Remotable;
import java.util.concurrent.TimeUnit;

@Remotable(value="worker")
public interface WorkerService {
    public void stopStreaming();

    public void startStreaming(Membership var1, String var2);

    public Status status();

    default public void ping() {
    }

    default public boolean ready() {
        return true;
    }

    default public JsonNode metrics() {
        return Metrics.toJsonNode();
    }

    default public void sleep(long seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    default public boolean stopped() {
        return this.status().getMembership() == null;
    }

    public static class Status {
        public static Status IDLE = new Status(null);
        private final Membership membership;

        public Status(@JsonProperty(value="membership") Membership membership) {
            this.membership = membership;
        }

        public Membership getMembership() {
            return this.membership;
        }

        public String toString() {
            return "Status{membership=" + String.valueOf(this.membership) + "}";
        }
    }
}

