/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul;

import com.couchbase.connector.cluster.Membership;
import com.couchbase.connector.cluster.consul.AsyncTask;
import com.couchbase.connector.cluster.consul.WorkerService;
import com.couchbase.connector.config.common.ImmutableGroupConfig;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.config.es.ImmutableConnectorConfig;
import com.couchbase.connector.elasticsearch.ElasticsearchConnector;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerServiceImpl
implements WorkerService,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerServiceImpl.class);
    private volatile WorkerService.Status status = WorkerService.Status.IDLE;
    private volatile AsyncTask connectorTask;
    private final Consumer<Throwable> fatalErrorListener;
    private ScheduledFuture killSwitch;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public WorkerServiceImpl(Consumer<Throwable> fatalErrorListener) {
        this.fatalErrorListener = Objects.requireNonNull(fatalErrorListener);
    }

    public synchronized void resetKillSwitchTimer() {
        if (this.killSwitch != null) {
            LOGGER.debug("Resetting kill switch.");
            this.stopKillSwitchTimer();
            this.startKillSwitchTimer();
        }
    }

    public synchronized void stopKillSwitchTimer() {
        if (this.killSwitch != null) {
            boolean cancelledSuccessfully = this.killSwitch.cancel(false);
            this.killSwitch = null;
        }
    }

    public synchronized void startKillSwitchTimer() {
        Preconditions.checkState((this.killSwitch == null ? 1 : 0) != 0, (Object)"kill switch timer already active");
        LOGGER.debug("Starting kill switch timer.");
        this.killSwitch = this.executor.schedule(() -> {
            LOGGER.error("Failed to renew Consul session; terminating.");
            System.exit(1);
        }, 20L, TimeUnit.SECONDS);
    }

    @Override
    public synchronized void stopStreaming() {
        this.stopKillSwitchTimer();
        if (this.connectorTask != null) {
            try {
                this.connectorTask.close();
                this.status = WorkerService.Status.IDLE;
            }
            catch (Throwable t) {
                LOGGER.error("Connector task failed to close. Terminating worker process.", t);
                System.exit(1);
            }
            finally {
                this.connectorTask = null;
            }
        }
    }

    @Override
    public synchronized void startStreaming(Membership membership, String config) {
        this.stopStreaming();
        this.startKillSwitchTimer();
        ImmutableConnectorConfig originalConfig = ConnectorConfig.from(config);
        ImmutableConnectorConfig patchedConfig = originalConfig.withGroup(ImmutableGroupConfig.copyOf(originalConfig.group()).withStaticMembership(membership));
        this.connectorTask = AsyncTask.run(() -> ElasticsearchConnector.run(patchedConfig), this.fatalErrorListener);
        this.status = new WorkerService.Status(membership);
    }

    @Override
    public synchronized WorkerService.Status status() {
        return this.status;
    }

    @Override
    public void close() {
        this.stopStreaming();
        this.executor.shutdownNow();
    }
}

