/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul.rpc;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.connector.cluster.consul.rpc.RpcEndpoint;
import com.couchbase.connector.cluster.consul.rpc.RpcResult;
import com.google.common.base.Stopwatch;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Broadcaster
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Broadcaster.class);
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public <S> Map<RpcEndpoint, RpcResult<Void>> broadcast(String description, List<RpcEndpoint> endpoints, Class<S> serviceInterface, Consumer<S> endpointCallback) {
        return this.broadcast(description, endpoints, serviceInterface, (S s) -> {
            endpointCallback.accept(s);
            return null;
        });
    }

    public <S, T> Map<RpcEndpoint, RpcResult<T>> broadcast(String description, List<RpcEndpoint> endpoints, Class<S> serviceInterface, Function<S, T> endpointCallback) {
        LOGGER.info("Broadcasting '{}' request to {} endpoints", (Object)description, (Object)endpoints.size());
        LOGGER.debug("Endpoints: {}", endpoints);
        Stopwatch timer = Stopwatch.createStarted();
        ArrayList<Future<RpcResult>> futures = new ArrayList<Future<RpcResult>>();
        for (RpcEndpoint endpoint : endpoints) {
            futures.add(this.executor.submit(() -> RpcResult.newSuccess(endpointCallback.apply(endpoint.service(serviceInterface)))));
        }
        LOGGER.info("Scheduled all '{}' requests for broadcast. Awaiting responses...", (Object)description);
        HashMap<RpcEndpoint, RpcResult<T>> results = new HashMap<RpcEndpoint, RpcResult<T>>();
        for (int i = 0; i < endpoints.size(); ++i) {
            RpcEndpoint endpoint = endpoints.get(i);
            Future f = (Future)futures.get(i);
            try {
                results.put(endpoint, (RpcResult)f.get());
                continue;
            }
            catch (Throwable e) {
                if (e instanceof ExecutionException) {
                    e = e.getCause();
                }
                results.put(endpoint, RpcResult.newFailure(e));
                LOGGER.error("Failed to apply '{}' callback for endpoint {}", new Object[]{description, RedactableArgument.redactSystem((Object)endpoint), e});
            }
        }
        LOGGER.info("Finished collecting '{}' broadcast responses. Broadcasting to {} endpoints took {}", new Object[]{description, endpoints.size(), timer});
        LOGGER.debug("Broadcast results: {}", results);
        return results;
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }
}

