/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul.rpc;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.connector.cluster.consul.ConsulDocumentWatcher;
import com.couchbase.connector.cluster.consul.ConsulHelper;
import com.couchbase.connector.cluster.consul.ReactorHelper;
import com.couchbase.connector.cluster.consul.rpc.EndpointDocument;
import com.couchbase.connector.elasticsearch.io.BackoffPolicy;
import com.couchbase.connector.elasticsearch.io.BackoffPolicyBuilder;
import com.couchbase.consul.ConsulOps;
import com.couchbase.consul.ConsulResponse;
import com.couchbase.consul.KvReadResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.therapi.jsonrpc.client.JsonRpcTransport;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulRpcTransport
implements JsonRpcTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulRpcTransport.class);
    private final String endpointKey;
    private final Duration timeout;
    private static final String requestIdPrefix = String.valueOf(UUID.randomUUID()) + "#";
    private static final AtomicLong requestCounter = new AtomicLong();
    private final ConsulDocumentWatcher watcher;
    private final ConsulOps.KvOps kv;

    public ConsulRpcTransport(ConsulOps.KvOps kv, ConsulDocumentWatcher watcher, String endpointKey, Duration timeout) {
        this.watcher = Objects.requireNonNull(watcher);
        this.endpointKey = Objects.requireNonNull(endpointKey);
        this.timeout = Objects.requireNonNull(timeout);
        this.kv = Objects.requireNonNull(kv);
    }

    public ConsulRpcTransport withTimeout(Duration timeout) {
        return new ConsulRpcTransport(this.kv, this.watcher, this.endpointKey, timeout);
    }

    private String nextRequestId() {
        return requestIdPrefix + requestCounter.getAndIncrement();
    }

    public JsonNode execute(ObjectMapper mapper, Object jsonRpcRequest) throws IOException {
        try {
            BackoffPolicy backoffPolicy = BackoffPolicyBuilder.constantBackoff(Duration.ofMillis(500L)).timeout(this.timeout).build();
            ConsulResponse<Optional<KvReadResult>> initialEndpointValue = ConsulHelper.getWithRetry(this.kv, this.endpointKey, backoffPolicy);
            ObjectNode requestNode = (ObjectNode)mapper.valueToTree(jsonRpcRequest);
            TextNode id = new TextNode(this.nextRequestId() + "::" + requestNode.path("method").asText());
            requestNode.set("id", (JsonNode)id);
            this.sendRequest(initialEndpointValue, mapper, requestNode);
            EndpointDocument endpointDocument = this.watcher.awaitCondition(this.endpointKey, json -> ConsulRpcTransport.readValueUnchecked(mapper, json, EndpointDocument.class), arg_0 -> ConsulRpcTransport.lambda$execute$1((JsonNode)id, arg_0), this.timeout).orElse(null);
            if (endpointDocument == null) {
                throw new IOException("Failed to receive RPC response; endpoint document does not exist: " + this.endpointKey);
            }
            JsonNode rpcResponse = (JsonNode)endpointDocument.findResponse((JsonNode)id).orElseThrow(() -> ConsulRpcTransport.lambda$execute$2((JsonNode)id));
            this.removeResponseFromEndpointDocument(mapper, (JsonNode)id);
            return rpcResponse;
        }
        catch (TimeoutException e) {
            throw new IOException("RPC endpoint operation timed out", e);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("RPC endpoint operation interrupted; " + e.getMessage());
        }
    }

    private static <T> T readValueUnchecked(ObjectMapper mapper, String json, Class<T> type) {
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Malformed RPC endpoint document", e);
        }
    }

    private void removeResponseFromEndpointDocument(ObjectMapper mapper, JsonNode id) throws IOException {
        ConsulResponse<Optional<KvReadResult>> initialEndpointValue = ReactorHelper.blockSingle(this.kv.readOneKey(this.endpointKey));
        if (initialEndpointValue.body().isEmpty()) {
            return;
        }
        ConsulHelper.atomicUpdate(this.kv, this.endpointKey, initialEndpointValue, value -> {
            try {
                if (Strings.isNullOrEmpty((String)value)) {
                    return value;
                }
                EndpointDocument doc = (EndpointDocument)mapper.readValue(value, EndpointDocument.class);
                doc.removeResponse(id);
                return mapper.writeValueAsString((Object)doc);
            }
            catch (IOException e) {
                LOGGER.error("Failed to remove response with ID {} from malformed RPC endpoint document,", (Object)id, (Object)e);
                return value;
            }
        });
    }

    private void sendRequest(ConsulResponse<Optional<KvReadResult>> initialEndpointValue, ObjectMapper mapper, ObjectNode requestNode) throws IOException {
        ConsulHelper.atomicUpdate(this.kv, this.endpointKey, initialEndpointValue, document -> {
            try {
                EndpointDocument endpoint = (EndpointDocument)mapper.readValue(document, EndpointDocument.class);
                endpoint.addRequest(requestNode);
                return mapper.writeValueAsString((Object)endpoint);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Malformed RPC endpoint document", e);
            }
        });
    }

    public String toString() {
        return "ConsulRpcTransport{endpointKey='" + String.valueOf(RedactableArgument.redactSystem((Object)this.endpointKey)) + "', timeout=" + String.valueOf(this.timeout) + "}";
    }

    private static /* synthetic */ AssertionError lambda$execute$2(JsonNode id) {
        return new AssertionError((Object)("Missing rpc response with id " + String.valueOf(id)));
    }

    private static /* synthetic */ boolean lambda$execute$1(JsonNode id, Optional endpoint) {
        return endpoint.isEmpty() || ((EndpointDocument)endpoint.get()).findResponse(id).isPresent();
    }
}

