/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul.rpc;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class EndpointDocument {
    private static final String TIMESTAMP = "timestamp";
    private final List<ObjectNode> requests;
    private final List<ObjectNode> responses;

    public EndpointDocument(@JsonProperty(value="requests") List<ObjectNode> requests, @JsonProperty(value="responses") List<ObjectNode> responses) {
        this.requests = requests != null ? requests : new ArrayList();
        this.responses = responses != null ? responses : new ArrayList();
    }

    public List<ObjectNode> getRequests() {
        return this.requests;
    }

    public List<ObjectNode> getResponses() {
        return this.responses;
    }

    public List<ObjectNode> removeResponsesOlderThan(Duration expiry) {
        long now = System.nanoTime();
        long expiryNanos = expiry.toNanos();
        ArrayList<ObjectNode> unclaimedResponses = new ArrayList<ObjectNode>();
        Iterator<ObjectNode> i = this.responses.iterator();
        while (i.hasNext()) {
            ObjectNode node = i.next();
            boolean expired = now - node.path(TIMESTAMP).longValue() > expiryNanos;
            if (!expired) continue;
            unclaimedResponses.add(node);
            i.remove();
        }
        return unclaimedResponses;
    }

    private static ObjectNode checkHasId(ObjectNode node) {
        JsonNode id = node.get("id");
        if (id == null) {
            throw new IllegalArgumentException("JSON-RPC node is missing 'id': " + String.valueOf(node));
        }
        EndpointDocument.checkIsValidJsonRpcId(id);
        return node;
    }

    private static void checkIsValidJsonRpcId(JsonNode id) {
        Preconditions.checkArgument((id.isTextual() || id.isNumber() || id.isNull() ? 1 : 0) != 0, (Object)"JSON-RPC ID must be String, Number, or NULL");
    }

    public void addRequest(ObjectNode request) {
        this.requests.add(EndpointDocument.checkHasId(request));
    }

    public void respond(ObjectNode response) {
        JsonNode id = EndpointDocument.checkHasId(response).get("id");
        response.set(TIMESTAMP, (JsonNode)new LongNode(System.nanoTime()));
        this.responses.add(response);
        this.requests.removeIf(request -> request.path("id").equals((Object)id));
    }

    public Optional<ObjectNode> firstRequest() {
        return this.requests.stream().findFirst();
    }

    public Optional<ObjectNode> findResponse(JsonNode id) {
        EndpointDocument.checkIsValidJsonRpcId(id);
        return this.responses.stream().filter(r -> r.path("id").equals((Object)id)).findFirst();
    }

    public boolean removeResponse(JsonNode id) {
        EndpointDocument.checkIsValidJsonRpcId(id);
        return this.responses.removeIf(r -> r.path("id").equals((Object)id));
    }

    public String toString() {
        return "EndpointDocument{requests=" + String.valueOf(this.requests) + ", responses=" + String.valueOf(this.responses) + "}";
    }
}

