/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul.rpc;

import com.couchbase.connector.cluster.consul.ConsulDocumentWatcher;
import com.couchbase.connector.cluster.consul.rpc.ConsulRpcTransport;
import com.couchbase.consul.ConsulOps;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.therapi.jackson.ObjectMappers;
import com.github.therapi.jsonrpc.client.JsonRpcTransport;
import com.github.therapi.jsonrpc.client.ServiceFactory;
import java.time.Duration;
import java.util.Objects;

public class RpcEndpoint {
    private static final ObjectMapper rpcObjectMapper = ObjectMappers.newLenientObjectMapper();
    private final ConsulRpcTransport transport;
    private final ServiceFactory serviceFactory;

    public RpcEndpoint(ConsulOps.KvOps kv, ConsulDocumentWatcher watcher, String endpointKey, Duration timeout) {
        this(new ConsulRpcTransport(kv, watcher, endpointKey, timeout));
    }

    public RpcEndpoint(ConsulRpcTransport transport) {
        this.transport = Objects.requireNonNull(transport);
        this.serviceFactory = new ServiceFactory(rpcObjectMapper, (JsonRpcTransport)transport);
    }

    public <T> T service(Class<T> remotableServiceInterface) {
        return (T)this.serviceFactory.createService(remotableServiceInterface);
    }

    public RpcEndpoint withTimeout(Duration timeout) {
        return new RpcEndpoint(this.transport.withTimeout(timeout));
    }

    public String toString() {
        return this.transport.toString();
    }
}

