/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul.rpc;

import com.google.common.base.Throwables;

public class RpcResult<T> {
    private final T result;
    private final Throwable failure;

    public static <T> RpcResult<T> newSuccess(T value) {
        return new RpcResult<T>(value, null);
    }

    public static <Void> RpcResult<Void> newSuccess() {
        return new RpcResult<Object>(null, null);
    }

    public static <T> RpcResult<T> newFailure(Throwable t) {
        return new RpcResult<Object>(null, t);
    }

    private RpcResult(T result, Throwable failure) {
        this.result = result;
        this.failure = failure;
    }

    public T get() {
        if (this.failure != null) {
            Throwables.throwIfUnchecked((Throwable)this.failure);
            throw new RuntimeException(this.failure);
        }
        return this.result;
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public String toString() {
        return "RpcResult{result=" + String.valueOf(this.result) + ", failure=" + String.valueOf(this.failure) + "}";
    }
}

