/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.consul.rpc;

import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.connector.cluster.consul.AbstractLongPollTask;
import com.couchbase.connector.cluster.consul.ConsulContext;
import com.couchbase.connector.cluster.consul.ConsulHelper;
import com.couchbase.connector.cluster.consul.ReactorHelper;
import com.couchbase.connector.cluster.consul.rpc.EndpointDocument;
import com.couchbase.consul.ConsulResponse;
import com.couchbase.consul.KvReadResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.therapi.jackson.ObjectMappers;
import com.github.therapi.jsonrpc.JsonRpcDispatcher;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServerTask
extends AbstractLongPollTask<RpcServerTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcServerTask.class);
    private static final Duration unclaimedResponseTtl = Duration.ofMinutes(5L);
    private static final ObjectMapper mapper = ObjectMappers.newLenientObjectMapper();
    private static final ObjectWriter objectWriter = mapper.writerWithDefaultPrettyPrinter();
    private final Consumer<Throwable> fatalErrorConsumer;
    private final String endpointId;
    private final String endpointKey;
    private final String sessionId;
    private final JsonRpcDispatcher dispatcher;
    private final ConsulContext ctx;

    public RpcServerTask(JsonRpcDispatcher dispatcher, ConsulContext ctx, String sessionId, String endpointId, Consumer<Throwable> fatalErrorConsumer) {
        super(ctx, "rpc-server-", sessionId);
        this.sessionId = Objects.requireNonNull(sessionId);
        this.fatalErrorConsumer = Objects.requireNonNull(fatalErrorConsumer);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.endpointId = Objects.requireNonNull(endpointId);
        this.endpointKey = ctx.keys().rpcEndpoint(endpointId);
        this.ctx = Objects.requireNonNull(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun(ConsulContext ctx, String sessionId) {
        try {
            this.bind();
            long index = 0L;
            while (!this.closed()) {
                ConsulResponse<Optional<KvReadResult>> response = ConsulHelper.awaitChange(ctx.client().kv(), this.endpointKey, index);
                if (response.body().isEmpty()) {
                    LOGGER.warn("RPC endpoint was deleted externally; will attempt to rebind");
                    this.bind();
                    index = 0L;
                    continue;
                }
                String json = response.body().get().valueAsString();
                EndpointDocument initialEndpoint = (EndpointDocument)mapper.readValue(json, EndpointDocument.class);
                ObjectNode jsonRpcRequest = initialEndpoint.firstRequest().orElse(null);
                if (jsonRpcRequest == null) {
                    LOGGER.debug("No unanswered requests.");
                } else {
                    ObjectNode invocationResult = this.execute(jsonRpcRequest);
                    ConsulHelper.atomicUpdate(ctx.client().kv(), this.endpointKey, response, document -> {
                        try {
                            EndpointDocument endpoint = (EndpointDocument)mapper.readValue(document, EndpointDocument.class);
                            List<ObjectNode> unclaimedResponses = endpoint.removeResponsesOlderThan(unclaimedResponseTtl);
                            if (!unclaimedResponses.isEmpty()) {
                                LOGGER.warn("Removed unclaimed responses (expired): {}", unclaimedResponses);
                            }
                            endpoint.respond(invocationResult);
                            return objectWriter.writeValueAsString((Object)endpoint);
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException("Malformed RPC endpoint document", e);
                        }
                    });
                    LOGGER.debug("Endpoint update complete");
                }
                index = ConsulHelper.requireModifyIndex(response);
            }
        }
        catch (Throwable t) {
            if (this.closed()) {
                if (CbThrowables.hasCause((Throwable)t, InterruptedException.class) || CbThrowables.hasCause((Throwable)t, InterruptedIOException.class)) {
                    LOGGER.debug("RPC server loop closed due to interruption. Don't panic; this is expected.");
                } else {
                    LOGGER.warn("Caught unexpected exception in RPC server loop after closing. It's probably nothing to worry about, but logging it just in case.", t);
                }
            } else {
                this.fatalErrorConsumer.accept(t);
            }
        }
        finally {
            try {
                LOGGER.info("Unbinding from RPC endpoint document {}", (Object)this.endpointKey);
                ctx.runCleanup(() -> ctx.unlockAndDelete(this.endpointKey, sessionId));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to unbind", (Throwable)e);
            }
        }
    }

    private ObjectNode execute(ObjectNode request) {
        if (!request.has("id")) {
            throw new IllegalArgumentException("JSON-RPC request node is missing 'id' (notifications not supported)");
        }
        return (ObjectNode)this.dispatcher.invoke(request.toString()).orElseThrow(() -> new AssertionError((Object)"missing response"));
    }

    private void bind() throws InterruptedException, EndpointAlreadyInUseException {
        while (!this.closed()) {
            LOGGER.info("Attempting to binding to RPC endpoint document {}", (Object)this.endpointKey);
            boolean acquired = this.ctx.acquireLock(this.endpointKey, "{}", this.sessionId);
            if (acquired) {
                LOGGER.info("Successfully bound to RPC endpoint document {}", (Object)this.endpointKey);
                return;
            }
            ConsulResponse<Optional<KvReadResult>> existing = ReactorHelper.blockSingle(this.ctx.client().kv().readOneKey(this.endpointKey, Map.of()));
            if (existing.body().isPresent()) {
                String lockSession = existing.body().get().session().orElse(null);
                throw new EndpointAlreadyInUseException("Failed to lock RPC endpoint document " + this.endpointKey + " ; already locked by session " + lockSession);
            }
            LOGGER.info("Endpoint lock acquisition failed; will retry after delay.");
            TimeUnit.SECONDS.sleep(1L);
        }
    }

    public static class EndpointAlreadyInUseException
    extends Exception {
        public EndpointAlreadyInUseException(String message) {
            super(message);
        }
    }
}

