/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.k8s;

import com.couchbase.connector.cluster.KillSwitch;
import com.couchbase.connector.cluster.PanicButton;
import com.couchbase.connector.cluster.k8s.StatefulSetInfo;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaChangeWatcher {
    private static final Logger log = LoggerFactory.getLogger(ReplicaChangeWatcher.class);
    private static final Duration resyncPeriod = Duration.ofSeconds(10L);
    private static final Duration killSwitchDeadline = resyncPeriod.multipliedBy(4L).plus(Duration.ofSeconds(3L));

    private ReplicaChangeWatcher() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static int getReplicasAndPanicOnChange(KubernetesClient client, final PanicButton panicButton) {
        try {
            StatefulSetInfo info = StatefulSetInfo.fromHostname();
            String k8sName = info.name;
            log.info("Kubernetes API version = {}", (Object)client.discovery().v1().getApiVersion());
            String namespace = client.discovery().v1().getNamespace();
            log.info("Kubernetes namespace = {}", (Object)namespace);
            StatefulSet statefulSet = (StatefulSet)((RollableScalableResource)((NonNamespaceOperation)client.apps().statefulSets().inNamespace(namespace)).withName(k8sName)).get();
            Objects.requireNonNull(statefulSet, "Failed to get StatefulSet in namespace '" + namespace + "' with name '" + k8sName + "'");
            final int initialReplicas = statefulSet.getSpec().getReplicas();
            log.info("StatefulSet replicas = {}", (Object)initialReplicas);
            log.info("Kubernetes API resync period = {} ; kill switch deadline = {}", (Object)resyncPeriod, (Object)killSwitchDeadline);
            final KillSwitch killSwitch = KillSwitch.start(killSwitchDeadline, () -> panicButton.panic("The connector contacts the Kubernetes API server every " + String.valueOf(resyncPeriod) + " to verify the StatefulSet's replica count has not changed, but " + String.valueOf(killSwitchDeadline) + " has elapsed without a successful response. Terminating to ensure multiple pods don't process the same Couchbase partitions."));
            SharedIndexInformer informer = ((RollableScalableResource)((NonNamespaceOperation)client.apps().statefulSets().inNamespace(namespace)).withName(k8sName)).inform((ResourceEventHandler)new ResourceEventHandler<StatefulSet>(){

                public void onUpdate(StatefulSet oldSet, StatefulSet newSet) {
                    killSwitch.reset();
                    int newReplicas = newSet.getSpec().getReplicas();
                    if (newReplicas != 0 && newReplicas != initialReplicas) {
                        panicButton.mildPanic("The connector is automatically restarting because it detected a change to the number of replicas in its StatefulSet. This is the intended behavior, and not a cause for alarm. Upon restart, the connector will wait for a quiet period to elapse, giving all pods a chance to notice the change and shut down. This prevents multiple pods from processing the same Couchbase partitions. There is a [very small] chance this strategy could fail, in which case stale versions of some documents could be written to Elasticsearch and remain until the documents are modified again in Couchbase. To be absolutely sure this never happens, we recommend first scaling the StatefulSet down to zero (or deleting it) and waiting for pods to terminate before scaling back up to the desired number of replicas.");
                    }
                }

                public void onAdd(StatefulSet it) {
                }

                public void onDelete(StatefulSet it, boolean deletedFinalStateUnknown) {
                }
            }, resyncPeriod.toMillis());
            return initialReplicas;
        }
        catch (Throwable t) {
            panicButton.panic("Failed to get/watch StatefulSet replica count.", t);
            throw t;
        }
    }

    public static Duration startupQuietPeriod() {
        return killSwitchDeadline.plus(Duration.ofSeconds(10L));
    }
}

