/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.cluster.k8s;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulSetInfo {
    private static final Logger log = LoggerFactory.getLogger(StatefulSetInfo.class);
    public final String name;
    public final int podOrdinal;

    public StatefulSetInfo(String name, int podOrdinal) {
        this.name = Objects.requireNonNull(name);
        this.podOrdinal = podOrdinal;
    }

    public String toString() {
        return "StatefulSetInfo{name='" + this.name + "', podOrdinal=" + this.podOrdinal + "}";
    }

    public static StatefulSetInfo fromHostname() {
        String hostname = System.getenv("HOSTNAME");
        Objects.requireNonNull(hostname, "HOSTNAME environment variable not set.");
        try {
            log.debug("HOSTNAME = {}", (Object)hostname);
            int separatorIndex = hostname.lastIndexOf("-");
            int ordinal = Integer.parseInt(hostname.substring(separatorIndex + 1));
            String statefulSetName = hostname.substring(0, separatorIndex);
            return new StatefulSetInfo(statefulSetName, ordinal);
        }
        catch (Exception e) {
            throw new RuntimeException("HOSTNAME environment variable '" + hostname + "' doesn't match <name>-<ordinal>. Make sure to deploy as StatefulSet.");
        }
    }
}

