/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.util.Golang;
import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.StorageSize;
import com.couchbase.connector.config.toml.ConfigTable;
import com.couchbase.connector.util.EnvironmentHelper;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.http.HttpHost;
import org.apache.tuweni.toml.Toml;
import org.apache.tuweni.toml.TomlParseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigHelper.class);

    public static HttpHost createHttpHost(String s, int defaultPort, boolean secure) {
        if (secure && StringUtils.startsWithIgnoreCase((CharSequence)s, (CharSequence)"http:")) {
            throw new ConfigException("Elasticsearch host URL " + s + " uses scheme 'http' which conflicts with 'secureConnection' setting of true. For a secure connection, omit the 'http://' prefix, or use prefix 'https://'.");
        }
        HttpHost host = HttpHost.create((String)s);
        if ("https".equals(host.getSchemeName()) && !secure) {
            throw new ConfigException("Elasticsearch host URL " + String.valueOf(host) + " uses https; must set elasticsearch 'secureConnection' config key to true.");
        }
        int port = host.getPort() == -1 ? defaultPort : host.getPort();
        return new HttpHost(host.getHostName(), port, secure ? "https" : "http");
    }

    public static Optional<StorageSize> getSize(ConfigTable toml, String dottedKey) {
        return toml.getString(dottedKey).map(it -> {
            try {
                return StorageSize.parse(it);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse storage size value '" + it + "' from config property '" + dottedKey + "' at " + String.valueOf(toml.inputPositionOf(dottedKey)) + "; " + e.getMessage());
            }
        });
    }

    public static Optional<Duration> getTime(ConfigTable toml, String dottedKey) {
        return toml.getString(dottedKey).map(it -> {
            try {
                return ConfigHelper.parseTime(it);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse duration value '" + it + "' from config property '" + dottedKey + "' at " + String.valueOf(toml.inputPositionOf(dottedKey)) + "; " + e.getMessage());
            }
        });
    }

    static Duration parseTime(String value) {
        String normalizedValue = value.toLowerCase(Locale.ROOT).trim().replaceAll("\\s+(\\D+)", "$1").replace("nanos", "ns").replace("micros", "us");
        return Golang.parseDuration((String)normalizedValue);
    }

    public static List<X509Certificate> readCertificates(ConfigTable parent, String parentName, String keyName) {
        List<X509Certificate> list;
        String path = parent.getString(keyName).orElse(null);
        if (StringUtils.isBlank((CharSequence)path)) {
            return Collections.emptyList();
        }
        File file = ConfigHelper.resolveIfRelative(path);
        String context = "File: '" + String.valueOf(file) + "' (specified as '" + path + "' at " + parentName + "." + keyName;
        FileInputStream is = new FileInputStream(file);
        try {
            List<X509Certificate> result = List.copyOf((List)ConfigHelper.getX509CertificateFactory().generateCertificates(is));
            if (result.isEmpty()) {
                LOGGER.warn("Certificate file contained zero certificates! " + context);
            }
            list = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigException("Failed to read certificate file; " + context, e);
            }
            catch (CertificateException e) {
                throw new ConfigException("Failed to parse certificate(s); expected one or more X.509 certificates in PEM format; " + context, e);
            }
        }
        ((InputStream)is).close();
        return list;
    }

    private static CertificateFactory getX509CertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new CouchbaseException("Could not instantiate X.509 CertificateFactory", (Throwable)e);
        }
    }

    public static String readPassword(ConfigTable parent, String parentName, String keyName) {
        String string;
        String pathToPassword = parent.getString(keyName).orElseThrow(() -> new ConfigException(parentName + "." + keyName + " must not be null"));
        File passwordFile = ConfigHelper.resolveIfRelative(pathToPassword);
        FileInputStream is = new FileInputStream(passwordFile);
        try {
            String password;
            TomlParseResult config = Toml.parse((String)ConfigHelper.resolveVariables(is));
            if (config.hasErrors()) {
                // empty if block
            }
            if ((password = config.getString("password")) == null) {
                throw new ConfigException("Failed to parse " + String.valueOf(passwordFile) + " : Expected a TOML file with contents like: password = 'swordfish'");
            }
            string = password;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new ConfigException("Error reading config at " + String.valueOf(parent.inputPositionOf(keyName)) + "; File not found: " + String.valueOf(passwordFile));
            }
            catch (IOException e) {
                LOGGER.error("Failed to read password from file {}", (Object)passwordFile, (Object)e);
                throw new ConfigException(e.getMessage());
            }
        }
        ((InputStream)is).close();
        return string;
    }

    public static void warnIfDeprecatedTypeNameIsPresent(ConfigTable config) {
        config.getString("typeName").ifPresent(it -> LOGGER.warn("The `typeName` config property is DEPRECATED, since Elasticsearch no longer has the concept of document types. Please remove the property from your config file; a future version of the connector will reject it as invalid."));
    }

    public static File resolveIfRelative(String pathToPassword) {
        File f = new File(pathToPassword);
        return f.isAbsolute() ? f : new File(EnvironmentHelper.getInstallDir(), pathToPassword);
    }

    public static String resolveVariables(String s) {
        return new StringSubstitutor(System::getenv).setValueDelimiter(":").replace(s);
    }

    public static String resolveVariables(InputStream is) throws IOException {
        return ConfigHelper.resolveVariables(new String(ByteStreams.toByteArray((InputStream)is), StandardCharsets.UTF_8));
    }
}

