/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config;

import java.util.Objects;

public class ScopeAndCollection {
    public static final ScopeAndCollection DEFAULT = new ScopeAndCollection("_default", "_default");
    private final String scope;
    private final String collection;

    public static ScopeAndCollection parse(String scopeAndCollection) {
        String[] split = scopeAndCollection.split("\\.", -1);
        if (split.length != 2) {
            throw new IllegalArgumentException("Expected qualified collection name (scope.collection) but got: " + scopeAndCollection);
        }
        return new ScopeAndCollection(split[0], split[1]);
    }

    public ScopeAndCollection(String scope, String collection) {
        this.scope = Objects.requireNonNull(scope);
        this.collection = Objects.requireNonNull(collection);
    }

    public String getScope() {
        return this.scope;
    }

    public String getCollection() {
        return this.collection;
    }

    public String format() {
        return this.scope + "." + this.collection;
    }

    public String toString() {
        return this.format();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopeAndCollection that = (ScopeAndCollection)o;
        return this.scope.equals(that.scope) && this.collection.equals(that.collection);
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.collection);
    }
}

