/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StorageSize {
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private final long bytes;

    public String toString() {
        return this.bytes + " bytes";
    }

    private StorageSize(long bytes) {
        this.bytes = bytes;
    }

    public static StorageSize ofBytes(long value) {
        return new StorageSize(value);
    }

    public static StorageSize ofMebibytes(long value) {
        return new StorageSize(value * 1024L * 1024L);
    }

    public long getBytes() {
        return this.bytes;
    }

    public static StorageSize parse(String value) {
        try {
            long scale;
            String normalized = value.trim().toLowerCase(Locale.ROOT);
            Matcher m = DIGITS.matcher(normalized);
            if (!m.find()) {
                throw new IllegalArgumentException("Value does not start with a number.");
            }
            String number = m.group();
            long num = Long.parseLong(number);
            String unit = normalized.substring(number.length()).trim();
            if (unit.isEmpty()) {
                throw new IllegalArgumentException("Missing size unit.");
            }
            switch (unit) {
                case "b": {
                    scale = 1L;
                    break;
                }
                case "k": 
                case "kb": {
                    scale = 1024L;
                    break;
                }
                case "m": 
                case "mb": {
                    scale = 0x100000L;
                    break;
                }
                case "g": 
                case "gb": {
                    scale = 0x40000000L;
                    break;
                }
                case "t": 
                case "tb": {
                    scale = 0x10000000000L;
                    break;
                }
                case "p": 
                case "pb": {
                    scale = 0x4000000000000L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized size unit: '" + unit + "'");
                }
            }
            return new StorageSize(Math.multiplyExact(num, scale));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse storage size value '" + value + "'; " + e.getMessage() + " ; A valid value is a number followed by a unit (for example, '10mb'). Valid units are 'b' for bytes, 'k' or 'kb' for kilobytes, 'm' or 'mb' for megabytes, 'g' or 'gb' for gigabytes, 't' or 'tb' for terabytes, 'p' or 'pb' for petabytes. Values must be >= 0 bytes and <= 9223372036854775807 bytes.");
        }
    }
}

