/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.common.ImmutableClientCertConfig;
import com.couchbase.connector.config.toml.ConfigPosition;
import com.couchbase.connector.config.toml.ConfigTable;
import com.couchbase.connector.util.KeyStoreHelper;
import com.google.common.base.Strings;
import java.security.KeyStore;
import org.immutables.value.Value;
import org.jspecify.annotations.Nullable;

@Value.Immutable
public interface ClientCertConfig {
    public boolean use();

    public String path();

    @Value.Redacted
    public @Nullable String password();

    @Value.Auxiliary
    public @Nullable ConfigPosition position();

    @Value.Lazy
    default public KeyStore getKeyStore() {
        return KeyStoreHelper.get(this.path(), this.position(), this.password());
    }

    public static ImmutableClientCertConfig from(ConfigTable config, String parent) {
        if (config.isEmpty()) {
            return ClientCertConfig.disabled();
        }
        String[] configProps = new String[]{"use", "path", "pathToPassword"};
        config.expectOnly(configProps);
        config.require(parent, configProps);
        if (!config.getRequiredBoolean("use")) {
            return ClientCertConfig.disabled();
        }
        return ImmutableClientCertConfig.builder().use(true).path(config.getRequiredString("path")).password(Strings.emptyToNull((String)ConfigHelper.readPassword(config, parent, "pathToPassword"))).position(config.inputPositionOf("path")).build();
    }

    public static ImmutableClientCertConfig disabled() {
        return ImmutableClientCertConfig.builder().use(false).password("").path("").build();
    }
}

