/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.Golang;
import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.common.ImmutableConsulConfig;
import com.couchbase.connector.config.toml.ConfigTable;
import com.couchbase.connector.config.toml.Toml;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(defaultAsDefault=true)
public interface ConsulConfig {
    @Value.Redacted
    public Optional<String> aclToken();

    default public boolean deregisterServiceOnGracefulShutdown() {
        return true;
    }

    default public Duration deregisterCriticalServiceAfter() {
        return Duration.ofDays(3L);
    }

    public static ImmutableConsulConfig from(ConfigTable root) {
        root.expectOnly("consul");
        ConfigTable config = root.getTableOrEmpty("consul");
        config.expectOnly("aclToken", "deregisterServiceOnGracefulShutdown", "deregisterCriticalServiceAfter");
        ImmutableConsulConfig.Builder builder = ImmutableConsulConfig.builder().aclToken(config.getString("aclToken").map(CbStrings::emptyToNull));
        config.getString("deregisterCriticalServiceAfter").map(Golang::parseDuration).ifPresent(it -> {
            if (it.compareTo(Duration.ofMinutes(1L)) < 0) {
                throw new ConfigException("Consul config property `deregisterCriticalServiceAfter` must be at least one minute, but got " + String.valueOf(it));
            }
            builder.deregisterCriticalServiceAfter((Duration)it);
        });
        config.getBoolean("deregisterServiceOnGracefulShutdown").ifPresent(builder::deregisterServiceOnGracefulShutdown);
        return builder.build();
    }

    public static ImmutableConsulConfig from(String toml) {
        return ConsulConfig.from(Toml.parse(ConfigHelper.resolveVariables(toml)));
    }

    public static ImmutableConsulConfig from(InputStream toml) throws IOException {
        return ConsulConfig.from(Toml.parse(ConfigHelper.resolveVariables(toml)));
    }

    public static ImmutableConsulConfig from(File toml) throws IOException {
        try (FileInputStream is = new FileInputStream(toml);){
            ImmutableConsulConfig immutableConsulConfig = ConsulConfig.from(is);
            return immutableConsulConfig;
        }
    }
}

