/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.ScopeAndCollection;
import com.couchbase.connector.config.common.ClientCertConfig;
import com.couchbase.connector.config.common.DcpConfig;
import com.couchbase.connector.config.common.ImmutableCouchbaseConfig;
import com.couchbase.connector.config.toml.ConfigTable;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.jspecify.annotations.Nullable;

@Value.Immutable
public interface CouchbaseConfig {
    public List<String> hosts();

    public NetworkResolution network();

    public String username();

    @Value.Redacted
    public String password();

    public String bucket();

    public String metadataBucket();

    @Value.Default
    default public ScopeAndCollection metadataCollection() {
        return ScopeAndCollection.DEFAULT;
    }

    @Value.Default
    default public DefaultCheckpoint defaultCheckpoint() {
        return DefaultCheckpoint.ZERO;
    }

    public @Nullable String scope();

    @Value.Default
    default public List<ScopeAndCollection> collections() {
        return ImmutableList.of();
    }

    public boolean secureConnection();

    @Value.Redacted
    public List<X509Certificate> caCert();

    public boolean hostnameVerification();

    public DcpConfig dcp();

    public ClientCertConfig clientCert();

    public Map<String, String> env();

    @Value.Check
    default public void check() {
        if (!Strings.isNullOrEmpty((String)this.scope()) && !this.collections().isEmpty()) {
            throw new ConfigException("Invalid configuration; you can specify 'scope' OR 'collections', but not both.");
        }
    }

    public static ImmutableCouchbaseConfig from(ConfigTable config) {
        config.expectOnly("bucket", "metadataBucket", "metadataCollection", "defaultCheckpoint", "scope", "collections", "hosts", "network", "username", "pathToPassword", "clientCertificate", "dcp", "secureConnection", "pathToCaCertificate", "hostnameVerification", "env");
        String sourceBucket = config.getString("bucket").orElse("default");
        String networkName = config.getString("network").orElse("auto");
        String metadataBucket = config.getString("metadataBucket").orElse("");
        String metadataCollection = config.getString("metadataCollection").orElse("_default._default");
        String parentConfigName = "couchbase";
        return ImmutableCouchbaseConfig.builder().bucket(sourceBucket).scope(config.getString("scope").orElse(null)).collections(config.getOptionalList("collections", ScopeAndCollection::parse)).metadataBucket(Strings.isNullOrEmpty((String)metadataBucket) ? sourceBucket : metadataBucket).metadataCollection(Strings.isNullOrEmpty((String)metadataCollection) ? ScopeAndCollection.DEFAULT : ScopeAndCollection.parse(metadataCollection)).defaultCheckpoint(config.getEnum("defaultCheckpoint", DefaultCheckpoint.class).orElse(DefaultCheckpoint.ZERO)).hosts(config.getRequiredStrings("hosts")).network(networkName.isEmpty() ? NetworkResolution.AUTO : NetworkResolution.valueOf((String)networkName)).username(config.getString("username").orElse("")).password(ConfigHelper.readPassword(config, parentConfigName, "pathToPassword")).secureConnection(config.getBoolean("secureConnection").orElse(false)).caCert(ConfigHelper.readCertificates(config, parentConfigName, "pathToCaCertificate")).hostnameVerification(config.getBoolean("hostnameVerification").orElse(true)).dcp(DcpConfig.from(config.getTableOrEmpty("dcp"))).clientCert(ClientCertConfig.from(config.getTableOrEmpty("clientCertificate"), "couchbase.clientCertificate")).env(CouchbaseConfig.parseEnv(config.getTableOrEmpty("env"))).build();
    }

    public static Map<String, String> parseEnv(ConfigTable env) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : env.dottedKeySet()) {
            Object value = env.get(key).orElseThrow(() -> new AssertionError((Object)("Where did the key '" + key + "' go?")));
            result.put(key, String.valueOf(value));
        }
        return result;
    }

    public static enum DefaultCheckpoint {
        ZERO,
        NOW;

    }
}

