/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.dcp.config.CompressionMode;
import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.StorageSize;
import com.couchbase.connector.config.common.ImmutableDcpConfig;
import com.couchbase.connector.config.toml.ConfigTable;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
public interface DcpConfig {
    public CompressionMode compression();

    public Duration persistencePollingInterval();

    public StorageSize flowControlBuffer();

    @Stability.Volatile
    public Duration connectTimeout();

    public static ImmutableDcpConfig from(ConfigTable config) {
        return ImmutableDcpConfig.builder().compression(config.getBoolean("compression").orElse(true) != false ? CompressionMode.ENABLED : CompressionMode.DISABLED).persistencePollingInterval(ConfigHelper.getTime(config, "persistencePollingInterval").orElse(Duration.ofMillis(100L))).flowControlBuffer(ConfigHelper.getSize(config, "flowControlBuffer").orElse(StorageSize.ofMebibytes(16L))).connectTimeout(ConfigHelper.getTime(config, "connectTimeout").orElse(Duration.ofSeconds(10L))).build();
    }
}

