/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.connector.cluster.Membership;
import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.common.ImmutableGroupConfig;
import com.couchbase.connector.config.toml.ConfigTable;
import org.immutables.value.Value;

@Value.Immutable
public interface GroupConfig {
    public String name();

    public Membership staticMembership();

    public static ImmutableGroupConfig from(ConfigTable config) {
        config.expectOnly("name", "static");
        ConfigTable staticGroup = config.getTableOrEmpty("static");
        staticGroup.expectOnly("memberNumber", "totalMembers");
        int totalMembers = staticGroup.getIntInRange("totalMembers", 1, 1024).orElseThrow(() -> new ConfigException("missing 'static.totalMembers' property"));
        int memberNumber = staticGroup.getInt("memberNumber").orElseThrow(() -> new ConfigException("missing 'static.memberNumber' property"));
        try {
            return ImmutableGroupConfig.builder().name(config.getString("name").orElseThrow(() -> new ConfigException("missing 'name' property"))).staticMembership(Membership.of(memberNumber, totalMembers)).build();
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(e.getMessage());
        }
    }
}

