/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.connector.config.common.ClientCertConfig;
import com.couchbase.connector.config.toml.ConfigPosition;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientCertConfig", generator="Immutables")
@Immutable
public final class ImmutableClientCertConfig
implements ClientCertConfig {
    private final boolean use;
    private final String path;
    private final @Nullable String password;
    private final @Nullable ConfigPosition position;
    private volatile transient long lazyInitBitmap;
    private static final long KEY_STORE_LAZY_INIT_BIT = 1L;
    private transient KeyStore keyStore;

    private ImmutableClientCertConfig(boolean use, String path, @Nullable String password, @Nullable ConfigPosition position) {
        this.use = use;
        this.path = path;
        this.password = password;
        this.position = position;
    }

    @Override
    public boolean use() {
        return this.use;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public @Nullable String password() {
        return this.password;
    }

    @Override
    public @Nullable ConfigPosition position() {
        return this.position;
    }

    public final ImmutableClientCertConfig withUse(boolean value) {
        if (this.use == value) {
            return this;
        }
        return new ImmutableClientCertConfig(value, this.path, this.password, this.position);
    }

    public final ImmutableClientCertConfig withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCertConfig(this.use, newValue, this.password, this.position);
    }

    public final ImmutableClientCertConfig withPassword(@Nullable String value) {
        if (Objects.equals(this.password, value)) {
            return this;
        }
        return new ImmutableClientCertConfig(this.use, this.path, value, this.position);
    }

    public final ImmutableClientCertConfig withPosition(@Nullable ConfigPosition value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutableClientCertConfig(this.use, this.path, this.password, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientCertConfig && this.equalTo(0, (ImmutableClientCertConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableClientCertConfig another) {
        return this.use == another.use && this.path.equals(another.path) && Objects.equals(this.password, another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.use);
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + Objects.hashCode(this.password);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ClientCertConfig").omitNullValues().add("use", this.use).add("path", (Object)this.path).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyStore getKeyStore() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableClientCertConfig immutableClientCertConfig = this;
            synchronized (immutableClientCertConfig) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.keyStore = Objects.requireNonNull(ClientCertConfig.super.getKeyStore(), "keyStore");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.keyStore;
    }

    public static ImmutableClientCertConfig copyOf(ClientCertConfig instance) {
        if (instance instanceof ImmutableClientCertConfig) {
            return (ImmutableClientCertConfig)instance;
        }
        return ImmutableClientCertConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClientCertConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USE = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private long initBits = 3L;
        private boolean use;
        @javax.annotation.Nullable
        private String path;
        @javax.annotation.Nullable
        private @Nullable String password;
        @javax.annotation.Nullable
        private @Nullable ConfigPosition position;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ClientCertConfig instance) {
            ConfigPosition positionValue;
            Objects.requireNonNull(instance, "instance");
            this.use(instance.use());
            this.path(instance.path());
            @Nullable String passwordValue = instance.password();
            if (passwordValue != null) {
                this.password(passwordValue);
            }
            if ((positionValue = instance.position()) != null) {
                this.position(positionValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder use(boolean use) {
            this.use = use;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder position(@Nullable ConfigPosition position) {
            this.position = position;
            return this;
        }

        public ImmutableClientCertConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClientCertConfig(this.use, this.path, this.password, this.position);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("use");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build ClientCertConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

