/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.connector.config.common.ConsulConfig;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConsulConfig", generator="Immutables")
@Immutable
public final class ImmutableConsulConfig
implements ConsulConfig {
    @Nullable
    private final String aclToken;
    private final boolean deregisterServiceOnGracefulShutdown;
    private final Duration deregisterCriticalServiceAfter;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableConsulConfig(Builder builder) {
        this.aclToken = builder.aclToken;
        if (builder.deregisterServiceOnGracefulShutdownIsSet()) {
            this.initShim.deregisterServiceOnGracefulShutdown(builder.deregisterServiceOnGracefulShutdown);
        }
        if (builder.deregisterCriticalServiceAfter != null) {
            this.initShim.deregisterCriticalServiceAfter(builder.deregisterCriticalServiceAfter);
        }
        this.deregisterServiceOnGracefulShutdown = this.initShim.deregisterServiceOnGracefulShutdown();
        this.deregisterCriticalServiceAfter = this.initShim.deregisterCriticalServiceAfter();
        this.initShim = null;
    }

    private ImmutableConsulConfig(@Nullable String aclToken, boolean deregisterServiceOnGracefulShutdown, Duration deregisterCriticalServiceAfter) {
        this.aclToken = aclToken;
        this.deregisterServiceOnGracefulShutdown = deregisterServiceOnGracefulShutdown;
        this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
        this.initShim = null;
    }

    private boolean deregisterServiceOnGracefulShutdownInitialize() {
        return ConsulConfig.super.deregisterServiceOnGracefulShutdown();
    }

    private Duration deregisterCriticalServiceAfterInitialize() {
        return ConsulConfig.super.deregisterCriticalServiceAfter();
    }

    @Override
    public Optional<String> aclToken() {
        return Optional.ofNullable(this.aclToken);
    }

    @Override
    public boolean deregisterServiceOnGracefulShutdown() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deregisterServiceOnGracefulShutdown() : this.deregisterServiceOnGracefulShutdown;
    }

    @Override
    public Duration deregisterCriticalServiceAfter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deregisterCriticalServiceAfter() : this.deregisterCriticalServiceAfter;
    }

    public final ImmutableConsulConfig withAclToken(String value) {
        String newValue = Objects.requireNonNull(value, "aclToken");
        if (Objects.equals(this.aclToken, newValue)) {
            return this;
        }
        return new ImmutableConsulConfig(newValue, this.deregisterServiceOnGracefulShutdown, this.deregisterCriticalServiceAfter);
    }

    public final ImmutableConsulConfig withAclToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.aclToken, value)) {
            return this;
        }
        return new ImmutableConsulConfig(value, this.deregisterServiceOnGracefulShutdown, this.deregisterCriticalServiceAfter);
    }

    public final ImmutableConsulConfig withDeregisterServiceOnGracefulShutdown(boolean value) {
        if (this.deregisterServiceOnGracefulShutdown == value) {
            return this;
        }
        return new ImmutableConsulConfig(this.aclToken, value, this.deregisterCriticalServiceAfter);
    }

    public final ImmutableConsulConfig withDeregisterCriticalServiceAfter(Duration value) {
        if (this.deregisterCriticalServiceAfter == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "deregisterCriticalServiceAfter");
        return new ImmutableConsulConfig(this.aclToken, this.deregisterServiceOnGracefulShutdown, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConsulConfig && this.equalTo(0, (ImmutableConsulConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableConsulConfig another) {
        return Objects.equals(this.aclToken, another.aclToken) && this.deregisterServiceOnGracefulShutdown == another.deregisterServiceOnGracefulShutdown && this.deregisterCriticalServiceAfter.equals(another.deregisterCriticalServiceAfter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.aclToken);
        h += (h << 5) + Booleans.hashCode((boolean)this.deregisterServiceOnGracefulShutdown);
        h += (h << 5) + this.deregisterCriticalServiceAfter.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConsulConfig").omitNullValues().add("deregisterServiceOnGracefulShutdown", this.deregisterServiceOnGracefulShutdown).add("deregisterCriticalServiceAfter", (Object)this.deregisterCriticalServiceAfter).toString();
    }

    public static ImmutableConsulConfig copyOf(ConsulConfig instance) {
        if (instance instanceof ImmutableConsulConfig) {
            return (ImmutableConsulConfig)instance;
        }
        return ImmutableConsulConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConsulConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_DEREGISTER_SERVICE_ON_GRACEFUL_SHUTDOWN = 1L;
        private long optBits;
        @Nullable
        private String aclToken;
        private boolean deregisterServiceOnGracefulShutdown;
        @Nullable
        private Duration deregisterCriticalServiceAfter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ConsulConfig instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> aclTokenOptional = instance.aclToken();
            if (aclTokenOptional.isPresent()) {
                this.aclToken(aclTokenOptional);
            }
            this.deregisterServiceOnGracefulShutdown(instance.deregisterServiceOnGracefulShutdown());
            this.deregisterCriticalServiceAfter(instance.deregisterCriticalServiceAfter());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder aclToken(String aclToken) {
            this.aclToken = Objects.requireNonNull(aclToken, "aclToken");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder aclToken(Optional<String> aclToken) {
            this.aclToken = aclToken.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deregisterServiceOnGracefulShutdown(boolean deregisterServiceOnGracefulShutdown) {
            this.deregisterServiceOnGracefulShutdown = deregisterServiceOnGracefulShutdown;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deregisterCriticalServiceAfter(Duration deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = Objects.requireNonNull(deregisterCriticalServiceAfter, "deregisterCriticalServiceAfter");
            return this;
        }

        public ImmutableConsulConfig build() {
            return new ImmutableConsulConfig(this);
        }

        private boolean deregisterServiceOnGracefulShutdownIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="ConsulConfig", generator="Immutables")
    private final class InitShim {
        private byte deregisterServiceOnGracefulShutdownBuildStage = 0;
        private boolean deregisterServiceOnGracefulShutdown;
        private byte deregisterCriticalServiceAfterBuildStage = 0;
        private Duration deregisterCriticalServiceAfter;

        private InitShim() {
        }

        boolean deregisterServiceOnGracefulShutdown() {
            if (this.deregisterServiceOnGracefulShutdownBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deregisterServiceOnGracefulShutdownBuildStage == 0) {
                this.deregisterServiceOnGracefulShutdownBuildStage = (byte)-1;
                this.deregisterServiceOnGracefulShutdown = ImmutableConsulConfig.this.deregisterServiceOnGracefulShutdownInitialize();
                this.deregisterServiceOnGracefulShutdownBuildStage = 1;
            }
            return this.deregisterServiceOnGracefulShutdown;
        }

        void deregisterServiceOnGracefulShutdown(boolean deregisterServiceOnGracefulShutdown) {
            this.deregisterServiceOnGracefulShutdown = deregisterServiceOnGracefulShutdown;
            this.deregisterServiceOnGracefulShutdownBuildStage = 1;
        }

        Duration deregisterCriticalServiceAfter() {
            if (this.deregisterCriticalServiceAfterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deregisterCriticalServiceAfterBuildStage == 0) {
                this.deregisterCriticalServiceAfterBuildStage = (byte)-1;
                this.deregisterCriticalServiceAfter = Objects.requireNonNull(ImmutableConsulConfig.this.deregisterCriticalServiceAfterInitialize(), "deregisterCriticalServiceAfter");
                this.deregisterCriticalServiceAfterBuildStage = 1;
            }
            return this.deregisterCriticalServiceAfter;
        }

        void deregisterCriticalServiceAfter(Duration deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
            this.deregisterCriticalServiceAfterBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.deregisterServiceOnGracefulShutdownBuildStage == -1) {
                attributes.add("deregisterServiceOnGracefulShutdown");
            }
            if (this.deregisterCriticalServiceAfterBuildStage == -1) {
                attributes.add("deregisterCriticalServiceAfter");
            }
            return "Cannot build ConsulConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }
}

