/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.connector.config.ScopeAndCollection;
import com.couchbase.connector.config.common.ClientCertConfig;
import com.couchbase.connector.config.common.CouchbaseConfig;
import com.couchbase.connector.config.common.DcpConfig;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CouchbaseConfig", generator="Immutables")
@Immutable
public final class ImmutableCouchbaseConfig
implements CouchbaseConfig {
    private final ImmutableList<String> hosts;
    private final NetworkResolution network;
    private final String username;
    private final String password;
    private final String bucket;
    private final String metadataBucket;
    private final ScopeAndCollection metadataCollection;
    private final CouchbaseConfig.DefaultCheckpoint defaultCheckpoint;
    private final @Nullable String scope;
    private final ImmutableList<ScopeAndCollection> collections;
    private final boolean secureConnection;
    private final ImmutableList<X509Certificate> caCert;
    private final boolean hostnameVerification;
    private final DcpConfig dcp;
    private final ClientCertConfig clientCert;
    private final ImmutableMap<String, String> env;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCouchbaseConfig(Builder builder) {
        this.hosts = builder.hosts.build();
        this.network = builder.network;
        this.username = builder.username;
        this.password = builder.password;
        this.bucket = builder.bucket;
        this.metadataBucket = builder.metadataBucket;
        this.scope = builder.scope;
        this.secureConnection = builder.secureConnection;
        this.caCert = builder.caCert.build();
        this.hostnameVerification = builder.hostnameVerification;
        this.dcp = builder.dcp;
        this.clientCert = builder.clientCert;
        this.env = builder.env.build();
        if (builder.metadataCollection != null) {
            this.initShim.metadataCollection(builder.metadataCollection);
        }
        if (builder.defaultCheckpoint != null) {
            this.initShim.defaultCheckpoint(builder.defaultCheckpoint);
        }
        if (builder.collectionsIsSet()) {
            this.initShim.collections((ImmutableList<ScopeAndCollection>)builder.collections.build());
        }
        this.metadataCollection = this.initShim.metadataCollection();
        this.defaultCheckpoint = this.initShim.defaultCheckpoint();
        this.collections = this.initShim.collections();
        this.initShim = null;
    }

    private ImmutableCouchbaseConfig(ImmutableList<String> hosts, NetworkResolution network, String username, String password, String bucket, String metadataBucket, ScopeAndCollection metadataCollection, CouchbaseConfig.DefaultCheckpoint defaultCheckpoint, @Nullable String scope, ImmutableList<ScopeAndCollection> collections, boolean secureConnection, ImmutableList<X509Certificate> caCert, boolean hostnameVerification, DcpConfig dcp, ClientCertConfig clientCert, ImmutableMap<String, String> env) {
        this.hosts = hosts;
        this.network = network;
        this.username = username;
        this.password = password;
        this.bucket = bucket;
        this.metadataBucket = metadataBucket;
        this.metadataCollection = metadataCollection;
        this.defaultCheckpoint = defaultCheckpoint;
        this.scope = scope;
        this.collections = collections;
        this.secureConnection = secureConnection;
        this.caCert = caCert;
        this.hostnameVerification = hostnameVerification;
        this.dcp = dcp;
        this.clientCert = clientCert;
        this.env = env;
        this.initShim = null;
    }

    private ScopeAndCollection metadataCollectionInitialize() {
        return CouchbaseConfig.super.metadataCollection();
    }

    private CouchbaseConfig.DefaultCheckpoint defaultCheckpointInitialize() {
        return CouchbaseConfig.super.defaultCheckpoint();
    }

    private List<ScopeAndCollection> collectionsInitialize() {
        return CouchbaseConfig.super.collections();
    }

    public ImmutableList<String> hosts() {
        return this.hosts;
    }

    @Override
    public NetworkResolution network() {
        return this.network;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    @Override
    public String metadataBucket() {
        return this.metadataBucket;
    }

    @Override
    public ScopeAndCollection metadataCollection() {
        InitShim shim = this.initShim;
        return shim != null ? shim.metadataCollection() : this.metadataCollection;
    }

    @Override
    public CouchbaseConfig.DefaultCheckpoint defaultCheckpoint() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultCheckpoint() : this.defaultCheckpoint;
    }

    @Override
    public @Nullable String scope() {
        return this.scope;
    }

    public ImmutableList<ScopeAndCollection> collections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.collections() : this.collections;
    }

    @Override
    public boolean secureConnection() {
        return this.secureConnection;
    }

    public ImmutableList<X509Certificate> caCert() {
        return this.caCert;
    }

    @Override
    public boolean hostnameVerification() {
        return this.hostnameVerification;
    }

    @Override
    public DcpConfig dcp() {
        return this.dcp;
    }

    @Override
    public ClientCertConfig clientCert() {
        return this.clientCert;
    }

    public ImmutableMap<String, String> env() {
        return this.env;
    }

    public final ImmutableCouchbaseConfig withHosts(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig((ImmutableList<String>)newValue, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withHosts(Iterable<String> elements) {
        if (this.hosts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig((ImmutableList<String>)newValue, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withNetwork(NetworkResolution value) {
        if (this.network == value) {
            return this;
        }
        NetworkResolution newValue = Objects.requireNonNull(value, "network");
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, newValue, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, newValue, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, newValue, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withBucket(String value) {
        String newValue = Objects.requireNonNull(value, "bucket");
        if (this.bucket.equals(newValue)) {
            return this;
        }
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, newValue, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withMetadataBucket(String value) {
        String newValue = Objects.requireNonNull(value, "metadataBucket");
        if (this.metadataBucket.equals(newValue)) {
            return this;
        }
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, newValue, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withMetadataCollection(ScopeAndCollection value) {
        if (this.metadataCollection == value) {
            return this;
        }
        ScopeAndCollection newValue = Objects.requireNonNull(value, "metadataCollection");
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, newValue, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withDefaultCheckpoint(CouchbaseConfig.DefaultCheckpoint value) {
        CouchbaseConfig.DefaultCheckpoint newValue = Objects.requireNonNull(value, "defaultCheckpoint");
        if (this.defaultCheckpoint == newValue) {
            return this;
        }
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, newValue, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, value, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withCollections(ScopeAndCollection ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, (ImmutableList<ScopeAndCollection>)newValue, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withCollections(Iterable<? extends ScopeAndCollection> elements) {
        if (this.collections == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, (ImmutableList<ScopeAndCollection>)newValue, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withSecureConnection(boolean value) {
        if (this.secureConnection == value) {
            return this;
        }
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, value, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withCaCert(X509Certificate ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, (ImmutableList<X509Certificate>)newValue, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withCaCert(Iterable<? extends X509Certificate> elements) {
        if (this.caCert == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, (ImmutableList<X509Certificate>)newValue, this.hostnameVerification, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withHostnameVerification(boolean value) {
        if (this.hostnameVerification == value) {
            return this;
        }
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, value, this.dcp, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withDcp(DcpConfig value) {
        if (this.dcp == value) {
            return this;
        }
        DcpConfig newValue = Objects.requireNonNull(value, "dcp");
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, newValue, this.clientCert, this.env));
    }

    public final ImmutableCouchbaseConfig withClientCert(ClientCertConfig value) {
        if (this.clientCert == value) {
            return this;
        }
        ClientCertConfig newValue = Objects.requireNonNull(value, "clientCert");
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, newValue, this.env));
    }

    public final ImmutableCouchbaseConfig withEnv(Map<String, ? extends String> entries) {
        if (this.env == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this.hosts, this.network, this.username, this.password, this.bucket, this.metadataBucket, this.metadataCollection, this.defaultCheckpoint, this.scope, this.collections, this.secureConnection, this.caCert, this.hostnameVerification, this.dcp, this.clientCert, (ImmutableMap<String, String>)newValue));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCouchbaseConfig && this.equalTo(0, (ImmutableCouchbaseConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableCouchbaseConfig another) {
        return this.hosts.equals(another.hosts) && this.network.equals((Object)another.network) && this.username.equals(another.username) && this.password.equals(another.password) && this.bucket.equals(another.bucket) && this.metadataBucket.equals(another.metadataBucket) && this.metadataCollection.equals(another.metadataCollection) && this.defaultCheckpoint.equals((Object)another.defaultCheckpoint) && Objects.equals(this.scope, another.scope) && this.collections.equals(another.collections) && this.secureConnection == another.secureConnection && this.caCert.equals(another.caCert) && this.hostnameVerification == another.hostnameVerification && this.dcp.equals(another.dcp) && this.clientCert.equals(another.clientCert) && this.env.equals(another.env);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hosts.hashCode();
        h += (h << 5) + this.network.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + this.bucket.hashCode();
        h += (h << 5) + this.metadataBucket.hashCode();
        h += (h << 5) + this.metadataCollection.hashCode();
        h += (h << 5) + this.defaultCheckpoint.hashCode();
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + this.collections.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.secureConnection);
        h += (h << 5) + this.caCert.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hostnameVerification);
        h += (h << 5) + this.dcp.hashCode();
        h += (h << 5) + this.clientCert.hashCode();
        h += (h << 5) + this.env.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CouchbaseConfig").omitNullValues().add("hosts", this.hosts).add("network", (Object)this.network).add("username", (Object)this.username).add("bucket", (Object)this.bucket).add("metadataBucket", (Object)this.metadataBucket).add("metadataCollection", (Object)this.metadataCollection).add("defaultCheckpoint", (Object)this.defaultCheckpoint).add("scope", (Object)this.scope).add("collections", this.collections).add("secureConnection", this.secureConnection).add("hostnameVerification", this.hostnameVerification).add("dcp", (Object)this.dcp).add("clientCert", (Object)this.clientCert).add("env", this.env).toString();
    }

    private static ImmutableCouchbaseConfig validate(ImmutableCouchbaseConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableCouchbaseConfig copyOf(CouchbaseConfig instance) {
        if (instance instanceof ImmutableCouchbaseConfig) {
            return (ImmutableCouchbaseConfig)instance;
        }
        return ImmutableCouchbaseConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CouchbaseConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NETWORK = 1L;
        private static final long INIT_BIT_USERNAME = 2L;
        private static final long INIT_BIT_PASSWORD = 4L;
        private static final long INIT_BIT_BUCKET = 8L;
        private static final long INIT_BIT_METADATA_BUCKET = 16L;
        private static final long INIT_BIT_SECURE_CONNECTION = 32L;
        private static final long INIT_BIT_HOSTNAME_VERIFICATION = 64L;
        private static final long INIT_BIT_DCP = 128L;
        private static final long INIT_BIT_CLIENT_CERT = 256L;
        private static final long OPT_BIT_COLLECTIONS = 1L;
        private long initBits = 511L;
        private long optBits;
        private ImmutableList.Builder<String> hosts = ImmutableList.builder();
        @javax.annotation.Nullable
        private NetworkResolution network;
        @javax.annotation.Nullable
        private String username;
        @javax.annotation.Nullable
        private String password;
        @javax.annotation.Nullable
        private String bucket;
        @javax.annotation.Nullable
        private String metadataBucket;
        @javax.annotation.Nullable
        private ScopeAndCollection metadataCollection;
        @javax.annotation.Nullable
        private CouchbaseConfig.DefaultCheckpoint defaultCheckpoint;
        @javax.annotation.Nullable
        private @Nullable String scope;
        private ImmutableList.Builder<ScopeAndCollection> collections = ImmutableList.builder();
        private boolean secureConnection;
        private ImmutableList.Builder<X509Certificate> caCert = ImmutableList.builder();
        private boolean hostnameVerification;
        @javax.annotation.Nullable
        private DcpConfig dcp;
        @javax.annotation.Nullable
        private ClientCertConfig clientCert;
        private ImmutableMap.Builder<String, String> env = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CouchbaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllHosts(instance.hosts());
            this.network(instance.network());
            this.username(instance.username());
            this.password(instance.password());
            this.bucket(instance.bucket());
            this.metadataBucket(instance.metadataBucket());
            this.metadataCollection(instance.metadataCollection());
            this.defaultCheckpoint(instance.defaultCheckpoint());
            @Nullable String scopeValue = instance.scope();
            if (scopeValue != null) {
                this.scope(scopeValue);
            }
            this.addAllCollections(instance.collections());
            this.secureConnection(instance.secureConnection());
            this.addAllCaCert(instance.caCert());
            this.hostnameVerification(instance.hostnameVerification());
            this.dcp(instance.dcp());
            this.clientCert(instance.clientCert());
            this.putAllEnv(instance.env());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHosts(String element) {
            this.hosts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHosts(String ... elements) {
            this.hosts.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hosts(Iterable<String> elements) {
            this.hosts = ImmutableList.builder();
            return this.addAllHosts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllHosts(Iterable<String> elements) {
            this.hosts.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder network(NetworkResolution network) {
            this.network = Objects.requireNonNull(network, "network");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bucket(String bucket) {
            this.bucket = Objects.requireNonNull(bucket, "bucket");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadataBucket(String metadataBucket) {
            this.metadataBucket = Objects.requireNonNull(metadataBucket, "metadataBucket");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadataCollection(ScopeAndCollection metadataCollection) {
            this.metadataCollection = Objects.requireNonNull(metadataCollection, "metadataCollection");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultCheckpoint(CouchbaseConfig.DefaultCheckpoint defaultCheckpoint) {
            this.defaultCheckpoint = Objects.requireNonNull(defaultCheckpoint, "defaultCheckpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCollections(ScopeAndCollection element) {
            this.collections.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCollections(ScopeAndCollection ... elements) {
            this.collections.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder collections(Iterable<? extends ScopeAndCollection> elements) {
            this.collections = ImmutableList.builder();
            return this.addAllCollections(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCollections(Iterable<? extends ScopeAndCollection> elements) {
            this.collections.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder secureConnection(boolean secureConnection) {
            this.secureConnection = secureConnection;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCaCert(X509Certificate element) {
            this.caCert.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCaCert(X509Certificate ... elements) {
            this.caCert.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder caCert(Iterable<? extends X509Certificate> elements) {
            this.caCert = ImmutableList.builder();
            return this.addAllCaCert(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCaCert(Iterable<? extends X509Certificate> elements) {
            this.caCert.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hostnameVerification(boolean hostnameVerification) {
            this.hostnameVerification = hostnameVerification;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dcp(DcpConfig dcp) {
            this.dcp = Objects.requireNonNull(dcp, "dcp");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientCert(ClientCertConfig clientCert) {
            this.clientCert = Objects.requireNonNull(clientCert, "clientCert");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putEnv(String key, String value) {
            this.env.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putEnv(Map.Entry<String, ? extends String> entry) {
            this.env.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder env(Map<String, ? extends String> entries) {
            this.env = ImmutableMap.builder();
            return this.putAllEnv(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllEnv(Map<String, ? extends String> entries) {
            this.env.putAll(entries);
            return this;
        }

        public ImmutableCouchbaseConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCouchbaseConfig.validate(new ImmutableCouchbaseConfig(this));
        }

        private boolean collectionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("network");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("password");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("bucket");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("metadataBucket");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("secureConnection");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("hostnameVerification");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("dcp");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("clientCert");
            }
            return "Cannot build CouchbaseConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Generated(from="CouchbaseConfig", generator="Immutables")
    private final class InitShim {
        private byte metadataCollectionBuildStage = 0;
        private ScopeAndCollection metadataCollection;
        private byte defaultCheckpointBuildStage = 0;
        private CouchbaseConfig.DefaultCheckpoint defaultCheckpoint;
        private byte collectionsBuildStage = 0;
        private ImmutableList<ScopeAndCollection> collections;

        private InitShim() {
        }

        ScopeAndCollection metadataCollection() {
            if (this.metadataCollectionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metadataCollectionBuildStage == 0) {
                this.metadataCollectionBuildStage = (byte)-1;
                this.metadataCollection = Objects.requireNonNull(ImmutableCouchbaseConfig.this.metadataCollectionInitialize(), "metadataCollection");
                this.metadataCollectionBuildStage = 1;
            }
            return this.metadataCollection;
        }

        void metadataCollection(ScopeAndCollection metadataCollection) {
            this.metadataCollection = metadataCollection;
            this.metadataCollectionBuildStage = 1;
        }

        CouchbaseConfig.DefaultCheckpoint defaultCheckpoint() {
            if (this.defaultCheckpointBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultCheckpointBuildStage == 0) {
                this.defaultCheckpointBuildStage = (byte)-1;
                this.defaultCheckpoint = Objects.requireNonNull(ImmutableCouchbaseConfig.this.defaultCheckpointInitialize(), "defaultCheckpoint");
                this.defaultCheckpointBuildStage = 1;
            }
            return this.defaultCheckpoint;
        }

        void defaultCheckpoint(CouchbaseConfig.DefaultCheckpoint defaultCheckpoint) {
            this.defaultCheckpoint = defaultCheckpoint;
            this.defaultCheckpointBuildStage = 1;
        }

        ImmutableList<ScopeAndCollection> collections() {
            if (this.collectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.collectionsBuildStage == 0) {
                this.collectionsBuildStage = (byte)-1;
                this.collections = ImmutableList.copyOf(ImmutableCouchbaseConfig.this.collectionsInitialize());
                this.collectionsBuildStage = 1;
            }
            return this.collections;
        }

        void collections(ImmutableList<ScopeAndCollection> collections) {
            this.collections = collections;
            this.collectionsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.metadataCollectionBuildStage == -1) {
                attributes.add("metadataCollection");
            }
            if (this.defaultCheckpointBuildStage == -1) {
                attributes.add("defaultCheckpoint");
            }
            if (this.collectionsBuildStage == -1) {
                attributes.add("collections");
            }
            return "Cannot build CouchbaseConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }
}

