/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.client.dcp.config.CompressionMode;
import com.couchbase.connector.config.StorageSize;
import com.couchbase.connector.config.common.DcpConfig;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DcpConfig", generator="Immutables")
@Immutable
public final class ImmutableDcpConfig
implements DcpConfig {
    private final CompressionMode compression;
    private final Duration persistencePollingInterval;
    private final StorageSize flowControlBuffer;
    private final Duration connectTimeout;

    private ImmutableDcpConfig(CompressionMode compression, Duration persistencePollingInterval, StorageSize flowControlBuffer, Duration connectTimeout) {
        this.compression = compression;
        this.persistencePollingInterval = persistencePollingInterval;
        this.flowControlBuffer = flowControlBuffer;
        this.connectTimeout = connectTimeout;
    }

    @Override
    public CompressionMode compression() {
        return this.compression;
    }

    @Override
    public Duration persistencePollingInterval() {
        return this.persistencePollingInterval;
    }

    @Override
    public StorageSize flowControlBuffer() {
        return this.flowControlBuffer;
    }

    @Override
    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public final ImmutableDcpConfig withCompression(CompressionMode value) {
        CompressionMode newValue = Objects.requireNonNull(value, "compression");
        if (this.compression == newValue) {
            return this;
        }
        return new ImmutableDcpConfig(newValue, this.persistencePollingInterval, this.flowControlBuffer, this.connectTimeout);
    }

    public final ImmutableDcpConfig withPersistencePollingInterval(Duration value) {
        if (this.persistencePollingInterval == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "persistencePollingInterval");
        return new ImmutableDcpConfig(this.compression, newValue, this.flowControlBuffer, this.connectTimeout);
    }

    public final ImmutableDcpConfig withFlowControlBuffer(StorageSize value) {
        if (this.flowControlBuffer == value) {
            return this;
        }
        StorageSize newValue = Objects.requireNonNull(value, "flowControlBuffer");
        return new ImmutableDcpConfig(this.compression, this.persistencePollingInterval, newValue, this.connectTimeout);
    }

    public final ImmutableDcpConfig withConnectTimeout(Duration value) {
        if (this.connectTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "connectTimeout");
        return new ImmutableDcpConfig(this.compression, this.persistencePollingInterval, this.flowControlBuffer, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDcpConfig && this.equalTo(0, (ImmutableDcpConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableDcpConfig another) {
        return this.compression.equals((Object)another.compression) && this.persistencePollingInterval.equals(another.persistencePollingInterval) && this.flowControlBuffer.equals(another.flowControlBuffer) && this.connectTimeout.equals(another.connectTimeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.compression.hashCode();
        h += (h << 5) + this.persistencePollingInterval.hashCode();
        h += (h << 5) + this.flowControlBuffer.hashCode();
        h += (h << 5) + this.connectTimeout.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DcpConfig").omitNullValues().add("compression", (Object)this.compression).add("persistencePollingInterval", (Object)this.persistencePollingInterval).add("flowControlBuffer", (Object)this.flowControlBuffer).add("connectTimeout", (Object)this.connectTimeout).toString();
    }

    public static ImmutableDcpConfig copyOf(DcpConfig instance) {
        if (instance instanceof ImmutableDcpConfig) {
            return (ImmutableDcpConfig)instance;
        }
        return ImmutableDcpConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DcpConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMPRESSION = 1L;
        private static final long INIT_BIT_PERSISTENCE_POLLING_INTERVAL = 2L;
        private static final long INIT_BIT_FLOW_CONTROL_BUFFER = 4L;
        private static final long INIT_BIT_CONNECT_TIMEOUT = 8L;
        private long initBits = 15L;
        @Nullable
        private CompressionMode compression;
        @Nullable
        private Duration persistencePollingInterval;
        @Nullable
        private StorageSize flowControlBuffer;
        @Nullable
        private Duration connectTimeout;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DcpConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.compression(instance.compression());
            this.persistencePollingInterval(instance.persistencePollingInterval());
            this.flowControlBuffer(instance.flowControlBuffer());
            this.connectTimeout(instance.connectTimeout());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder compression(CompressionMode compression) {
            this.compression = Objects.requireNonNull(compression, "compression");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder persistencePollingInterval(Duration persistencePollingInterval) {
            this.persistencePollingInterval = Objects.requireNonNull(persistencePollingInterval, "persistencePollingInterval");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder flowControlBuffer(StorageSize flowControlBuffer) {
            this.flowControlBuffer = Objects.requireNonNull(flowControlBuffer, "flowControlBuffer");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = Objects.requireNonNull(connectTimeout, "connectTimeout");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableDcpConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDcpConfig(this.compression, this.persistencePollingInterval, this.flowControlBuffer, this.connectTimeout);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("compression");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("persistencePollingInterval");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("flowControlBuffer");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("connectTimeout");
            }
            return "Cannot build DcpConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

