/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.connector.cluster.Membership;
import com.couchbase.connector.config.common.GroupConfig;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GroupConfig", generator="Immutables")
@Immutable
public final class ImmutableGroupConfig
implements GroupConfig {
    private final String name;
    private final Membership staticMembership;

    private ImmutableGroupConfig(String name, Membership staticMembership) {
        this.name = name;
        this.staticMembership = staticMembership;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Membership staticMembership() {
        return this.staticMembership;
    }

    public final ImmutableGroupConfig withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableGroupConfig(newValue, this.staticMembership);
    }

    public final ImmutableGroupConfig withStaticMembership(Membership value) {
        if (this.staticMembership == value) {
            return this;
        }
        Membership newValue = Objects.requireNonNull(value, "staticMembership");
        return new ImmutableGroupConfig(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupConfig && this.equalTo(0, (ImmutableGroupConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupConfig another) {
        return this.name.equals(another.name) && this.staticMembership.equals(another.staticMembership);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.staticMembership.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GroupConfig").omitNullValues().add("name", (Object)this.name).add("staticMembership", (Object)this.staticMembership).toString();
    }

    public static ImmutableGroupConfig copyOf(GroupConfig instance) {
        if (instance instanceof ImmutableGroupConfig) {
            return (ImmutableGroupConfig)instance;
        }
        return ImmutableGroupConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GroupConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_STATIC_MEMBERSHIP = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private Membership staticMembership;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GroupConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.staticMembership(instance.staticMembership());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder staticMembership(Membership staticMembership) {
            this.staticMembership = Objects.requireNonNull(staticMembership, "staticMembership");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGroupConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroupConfig(this.name, this.staticMembership);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("staticMembership");
            }
            return "Cannot build GroupConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

