/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.client.core.logging.RedactionLevel;
import com.couchbase.connector.config.common.LoggingConfig;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LoggingConfig", generator="Immutables")
@Immutable
public final class ImmutableLoggingConfig
implements LoggingConfig {
    private final boolean logDocumentLifecycle;
    private final RedactionLevel redactionLevel;

    private ImmutableLoggingConfig(boolean logDocumentLifecycle, RedactionLevel redactionLevel) {
        this.logDocumentLifecycle = logDocumentLifecycle;
        this.redactionLevel = redactionLevel;
    }

    @Override
    public boolean logDocumentLifecycle() {
        return this.logDocumentLifecycle;
    }

    @Override
    public RedactionLevel redactionLevel() {
        return this.redactionLevel;
    }

    public final ImmutableLoggingConfig withLogDocumentLifecycle(boolean value) {
        if (this.logDocumentLifecycle == value) {
            return this;
        }
        return new ImmutableLoggingConfig(value, this.redactionLevel);
    }

    public final ImmutableLoggingConfig withRedactionLevel(RedactionLevel value) {
        RedactionLevel newValue = Objects.requireNonNull(value, "redactionLevel");
        if (this.redactionLevel == newValue) {
            return this;
        }
        return new ImmutableLoggingConfig(this.logDocumentLifecycle, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoggingConfig && this.equalTo(0, (ImmutableLoggingConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableLoggingConfig another) {
        return this.logDocumentLifecycle == another.logDocumentLifecycle && this.redactionLevel.equals((Object)another.redactionLevel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.logDocumentLifecycle);
        h += (h << 5) + this.redactionLevel.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LoggingConfig").omitNullValues().add("logDocumentLifecycle", this.logDocumentLifecycle).add("redactionLevel", (Object)this.redactionLevel).toString();
    }

    public static ImmutableLoggingConfig copyOf(LoggingConfig instance) {
        if (instance instanceof ImmutableLoggingConfig) {
            return (ImmutableLoggingConfig)instance;
        }
        return ImmutableLoggingConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LoggingConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOG_DOCUMENT_LIFECYCLE = 1L;
        private static final long INIT_BIT_REDACTION_LEVEL = 2L;
        private long initBits = 3L;
        private boolean logDocumentLifecycle;
        @Nullable
        private RedactionLevel redactionLevel;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LoggingConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.logDocumentLifecycle(instance.logDocumentLifecycle());
            this.redactionLevel(instance.redactionLevel());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logDocumentLifecycle(boolean logDocumentLifecycle) {
            this.logDocumentLifecycle = logDocumentLifecycle;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder redactionLevel(RedactionLevel redactionLevel) {
            this.redactionLevel = Objects.requireNonNull(redactionLevel, "redactionLevel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableLoggingConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLoggingConfig(this.logDocumentLifecycle, this.redactionLevel);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("logDocumentLifecycle");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("redactionLevel");
            }
            return "Cannot build LoggingConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

