/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.connector.config.common.MetricsConfig;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MetricsConfig", generator="Immutables")
@Immutable
public final class ImmutableMetricsConfig
implements MetricsConfig {
    private final Duration logInterval;
    private final int httpPort;

    private ImmutableMetricsConfig(Duration logInterval, int httpPort) {
        this.logInterval = logInterval;
        this.httpPort = httpPort;
    }

    @Override
    public Duration logInterval() {
        return this.logInterval;
    }

    @Override
    public int httpPort() {
        return this.httpPort;
    }

    public final ImmutableMetricsConfig withLogInterval(Duration value) {
        if (this.logInterval == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "logInterval");
        return new ImmutableMetricsConfig(newValue, this.httpPort);
    }

    public final ImmutableMetricsConfig withHttpPort(int value) {
        if (this.httpPort == value) {
            return this;
        }
        return new ImmutableMetricsConfig(this.logInterval, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetricsConfig && this.equalTo(0, (ImmutableMetricsConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetricsConfig another) {
        return this.logInterval.equals(another.logInterval) && this.httpPort == another.httpPort;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.logInterval.hashCode();
        h += (h << 5) + this.httpPort;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetricsConfig").omitNullValues().add("logInterval", (Object)this.logInterval).add("httpPort", this.httpPort).toString();
    }

    public static ImmutableMetricsConfig copyOf(MetricsConfig instance) {
        if (instance instanceof ImmutableMetricsConfig) {
            return (ImmutableMetricsConfig)instance;
        }
        return ImmutableMetricsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MetricsConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOG_INTERVAL = 1L;
        private static final long INIT_BIT_HTTP_PORT = 2L;
        private long initBits = 3L;
        @Nullable
        private Duration logInterval;
        private int httpPort;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MetricsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.logInterval(instance.logInterval());
            this.httpPort(instance.httpPort());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logInterval(Duration logInterval) {
            this.logInterval = Objects.requireNonNull(logInterval, "logInterval");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder httpPort(int httpPort) {
            this.httpPort = httpPort;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMetricsConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMetricsConfig(this.logInterval, this.httpPort);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("logInterval");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("httpPort");
            }
            return "Cannot build MetricsConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

