/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.connector.config.common.TrustStoreConfig;
import com.couchbase.connector.config.toml.ConfigPosition;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TrustStoreConfig", generator="Immutables")
@Immutable
public final class ImmutableTrustStoreConfig
implements TrustStoreConfig {
    private final String path;
    private final @Nullable String password;
    private final @Nullable ConfigPosition position;
    private volatile transient long lazyInitBitmap;
    private static final long GET_LAZY_INIT_BIT = 1L;
    private transient KeyStore get;

    private ImmutableTrustStoreConfig(String path, @Nullable String password, @Nullable ConfigPosition position) {
        this.path = path;
        this.password = password;
        this.position = position;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public @Nullable String password() {
        return this.password;
    }

    @Override
    public @Nullable ConfigPosition position() {
        return this.position;
    }

    public final ImmutableTrustStoreConfig withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableTrustStoreConfig(newValue, this.password, this.position);
    }

    public final ImmutableTrustStoreConfig withPassword(@Nullable String value) {
        if (Objects.equals(this.password, value)) {
            return this;
        }
        return new ImmutableTrustStoreConfig(this.path, value, this.position);
    }

    public final ImmutableTrustStoreConfig withPosition(@Nullable ConfigPosition value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutableTrustStoreConfig(this.path, this.password, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTrustStoreConfig && this.equalTo(0, (ImmutableTrustStoreConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableTrustStoreConfig another) {
        return this.path.equals(another.path) && Objects.equals(this.password, another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + Objects.hashCode(this.password);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TrustStoreConfig").omitNullValues().add("path", (Object)this.path).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyStore get() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableTrustStoreConfig immutableTrustStoreConfig = this;
            synchronized (immutableTrustStoreConfig) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.get = Objects.requireNonNull(TrustStoreConfig.super.get(), "get");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.get;
    }

    public static ImmutableTrustStoreConfig copyOf(TrustStoreConfig instance) {
        if (instance instanceof ImmutableTrustStoreConfig) {
            return (ImmutableTrustStoreConfig)instance;
        }
        return ImmutableTrustStoreConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TrustStoreConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATH = 1L;
        private long initBits = 1L;
        @javax.annotation.Nullable
        private String path;
        @javax.annotation.Nullable
        private @Nullable String password;
        @javax.annotation.Nullable
        private @Nullable ConfigPosition position;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TrustStoreConfig instance) {
            ConfigPosition positionValue;
            Objects.requireNonNull(instance, "instance");
            this.path(instance.path());
            @Nullable String passwordValue = instance.password();
            if (passwordValue != null) {
                this.password(passwordValue);
            }
            if ((positionValue = instance.position()) != null) {
                this.position(positionValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder position(@Nullable ConfigPosition position) {
            this.position = position;
            return this;
        }

        public ImmutableTrustStoreConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTrustStoreConfig(this.path, this.password, this.position);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build TrustStoreConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

