/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.client.core.logging.RedactionLevel;
import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.common.ImmutableLoggingConfig;
import com.couchbase.connector.config.toml.ConfigTable;
import org.immutables.value.Value;

@Value.Immutable
public interface LoggingConfig {
    public boolean logDocumentLifecycle();

    public RedactionLevel redactionLevel();

    public static ImmutableLoggingConfig from(ConfigTable config) {
        config.expectOnly("logDocumentLifecycle", "redactionLevel");
        try {
            return ImmutableLoggingConfig.builder().logDocumentLifecycle(config.getBoolean("logDocumentLifecycle").orElse(false)).redactionLevel(config.getEnum("redactionLevel", RedactionLevel.class).orElse(RedactionLevel.NONE)).build();
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(e.getMessage());
        }
    }
}

