/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.common.ImmutableMetricsConfig;
import com.couchbase.connector.config.toml.ConfigTable;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
public interface MetricsConfig {
    public Duration logInterval();

    public int httpPort();

    public static ImmutableMetricsConfig from(ConfigTable config) {
        config.expectOnly("logInterval", "httpPort");
        return ImmutableMetricsConfig.builder().logInterval(ConfigHelper.getTime(config, "logInterval").orElse(Duration.ofMinutes(1L))).httpPort(config.getIntInRange("httpPort", -1, 65535).orElse(-1)).build();
    }
}

