/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.common;

import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.common.ImmutableTrustStoreConfig;
import com.couchbase.connector.config.toml.ConfigPosition;
import com.couchbase.connector.config.toml.ConfigTable;
import com.couchbase.connector.util.KeyStoreHelper;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import java.security.KeyStore;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public interface TrustStoreConfig
extends Supplier<KeyStore> {
    public static final Logger log = LoggerFactory.getLogger(TrustStoreConfig.class);

    public String path();

    @Value.Redacted
    public @Nullable String password();

    @Value.Auxiliary
    public @Nullable ConfigPosition position();

    @Value.Lazy
    default public KeyStore get() {
        return KeyStoreHelper.get(this.path(), this.position(), this.password());
    }

    public static Optional<ImmutableTrustStoreConfig> from(ConfigTable config) {
        config.expectOnly("path", "pathToPassword");
        String path = config.getString("path").orElse(null);
        if (StringUtils.isBlank((CharSequence)path) || path.equals("path/to/truststore")) {
            return Optional.empty();
        }
        log.warn("The [truststore] config section is deprecated. Please use the 'pathToCaCertificate' properties instead.");
        String password = ConfigHelper.readPassword(config, "truststore", "pathToPassword");
        return Optional.of(ImmutableTrustStoreConfig.builder().path(config.getRequiredString("path")).password(Strings.emptyToNull((String)password)).position(config.inputPositionOf("path")).build());
    }
}

