/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.es;

import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.StorageSize;
import com.couchbase.connector.config.es.ImmutableBulkRequestConfig;
import com.couchbase.connector.config.toml.ConfigTable;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
public interface BulkRequestConfig {
    public int maxActions();

    public StorageSize maxBytes();

    public int concurrentRequests();

    public Duration timeout();

    @Value.Check
    default public void check() {
        if (this.concurrentRequests() <= 0) {
            throw new IllegalArgumentException("concurrentRequests must be > 0");
        }
    }

    public static ImmutableBulkRequestConfig from(ConfigTable config) {
        config.expectOnly("actions", "bytes", "timeout", "concurrentRequests");
        return ImmutableBulkRequestConfig.builder().maxActions(config.getInt("actions").orElse(1000)).maxBytes(ConfigHelper.getSize(config, "bytes").orElse(StorageSize.ofMebibytes(10L))).timeout(ConfigHelper.getTime(config, "timeout").orElse(Duration.ofMinutes(1L))).concurrentRequests(config.getIntInRange("concurrentRequests", 1, 16).orElse(2)).build();
    }
}

