/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.es;

import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.common.CouchbaseConfig;
import com.couchbase.connector.config.common.GroupConfig;
import com.couchbase.connector.config.common.LoggingConfig;
import com.couchbase.connector.config.common.MetricsConfig;
import com.couchbase.connector.config.common.TrustStoreConfig;
import com.couchbase.connector.config.es.ElasticsearchConfig;
import com.couchbase.connector.config.es.ImmutableConnectorConfig;
import com.couchbase.connector.config.toml.ConfigTable;
import com.couchbase.connector.config.toml.Toml;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface ConnectorConfig {
    public CouchbaseConfig couchbase();

    public ElasticsearchConfig elasticsearch();

    public LoggingConfig logging();

    public MetricsConfig metrics();

    public GroupConfig group();

    public Optional<TrustStoreConfig> trustStore();

    public static ImmutableConnectorConfig from(ConfigTable config) {
        config.expectOnly("couchbase", "elasticsearch", "logging", "metrics", "group", "truststore");
        return ImmutableConnectorConfig.builder().couchbase(CouchbaseConfig.from(config.getTableOrEmpty("couchbase"))).elasticsearch(ElasticsearchConfig.from(config.getTableOrEmpty("elasticsearch"))).logging(LoggingConfig.from(config.getTableOrEmpty("logging"))).metrics(MetricsConfig.from(config.getTableOrEmpty("metrics"))).group(GroupConfig.from(config.getTableOrEmpty("group"))).trustStore(TrustStoreConfig.from(config.getTableOrEmpty("truststore"))).build();
    }

    public static ImmutableConnectorConfig from(String toml) {
        return ConnectorConfig.from(Toml.parse(ConfigHelper.resolveVariables(toml)));
    }

    public static ImmutableConnectorConfig from(InputStream toml) throws IOException {
        return ConnectorConfig.from(Toml.parse(ConfigHelper.resolveVariables(toml)));
    }

    public static ImmutableConnectorConfig from(File toml) throws IOException {
        try (FileInputStream is = new FileInputStream(toml);){
            ImmutableConnectorConfig immutableConnectorConfig = ConnectorConfig.from(is);
            return immutableConnectorConfig;
        }
    }
}

