/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.es;

import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.common.ClientCertConfig;
import com.couchbase.connector.config.common.ImmutableClientCertConfig;
import com.couchbase.connector.config.es.AwsConfig;
import com.couchbase.connector.config.es.BulkRequestConfig;
import com.couchbase.connector.config.es.DocStructureConfig;
import com.couchbase.connector.config.es.ElasticCloudConfig;
import com.couchbase.connector.config.es.ImmutableAwsConfig;
import com.couchbase.connector.config.es.ImmutableElasticCloudConfig;
import com.couchbase.connector.config.es.ImmutableElasticsearchConfig;
import com.couchbase.connector.config.es.ImmutableTypeConfig;
import com.couchbase.connector.config.es.RejectLogConfig;
import com.couchbase.connector.config.es.TypeConfig;
import com.couchbase.connector.config.toml.ConfigArray;
import com.couchbase.connector.config.toml.ConfigTable;
import com.google.common.collect.ImmutableList;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value.Immutable
public interface ElasticsearchConfig {
    public ImmutableList<HttpHost> hosts();

    public String username();

    @Value.Redacted
    public String password();

    public boolean secureConnection();

    @Value.Redacted
    public List<X509Certificate> caCert();

    public ClientCertConfig clientCert();

    public BulkRequestConfig bulkRequest();

    public DocStructureConfig docStructure();

    public ImmutableList<TypeConfig> types();

    public RejectLogConfig rejectLog();

    public ElasticCloudConfig elasticCloud();

    public AwsConfig aws();

    @Value.Check
    default public void check() {
        if (this.types().isEmpty()) {
            throw new ConfigException("Must declare at least one [[elasticsearch.type]]");
        }
    }

    public static ImmutableElasticsearchConfig from(ConfigTable config) {
        config.expectOnly("hosts", "username", "pathToPassword", "secureConnection", "pathToCaCertificate", "clientCertificate", "elasticCloud", "aws", "bulkRequestLimits", "docStructure", "typeDefaults", "type", "rejectionLog");
        ImmutableElasticCloudConfig elasticCloud = ElasticCloudConfig.from(config.getTableOrEmpty("elasticCloud"));
        ImmutableAwsConfig aws = AwsConfig.from(config.getTableOrEmpty("aws"));
        ImmutableClientCertConfig clientCert = ClientCertConfig.from(config.getTableOrEmpty("clientCertificate"), "elasticsearch.clientCertificate");
        boolean isCloudService = elasticCloud.enabled() || !aws.region().isEmpty();
        boolean secureConnection = config.getBoolean("secureConnection").orElse(false);
        if (isCloudService && !secureConnection) {
            throw new ConfigException("The Elasticsearch service specified in the connector config requires `secureConnection = true` in the [elasticsearch] config section.");
        }
        int defaultPort = isCloudService ? 443 : 9200;
        String parentConfigName = "elasticsearch";
        ImmutableElasticsearchConfig.Builder builder = ImmutableElasticsearchConfig.builder().secureConnection(secureConnection).caCert(ConfigHelper.readCertificates(config, parentConfigName, "pathToCaCertificate")).hosts(config.getRequiredStrings("hosts").stream().map(h -> StringUtils.removeEnd((String)h, (String)"/")).map(h -> ConfigHelper.createHttpHost(h, defaultPort, secureConnection)).collect(Collectors.toList())).username(config.getString("username").orElse("")).password(ConfigHelper.readPassword(config, parentConfigName, "pathToPassword")).bulkRequest(BulkRequestConfig.from(config.getTableOrEmpty("bulkRequestLimits"))).elasticCloud(elasticCloud).aws(aws).clientCert(clientCert).docStructure(DocStructureConfig.from(config.getTableOrEmpty("docStructure")));
        ConfigTable typeDefaults = config.getTableOrEmpty("typeDefaults");
        typeDefaults.expectOnly("typeName", "index", "pipeline", "ignore", "ignoreDeletes", "matchOnQualifiedKey");
        ConfigHelper.warnIfDeprecatedTypeNameIsPresent(typeDefaults);
        ImmutableTypeConfig defaultTypeConfig = ImmutableTypeConfig.builder().index(typeDefaults.getString("index").orElse(null)).pipeline(typeDefaults.getString("pipeline").orElse(null)).ignore(typeDefaults.getBoolean("ignore").orElse(false)).ignoreDeletes(typeDefaults.getBoolean("ignoreDeletes").orElse(false)).matchOnQualifiedKey(typeDefaults.getBoolean("matchOnQualifiedKey").orElse(false)).matcher(s -> null).build();
        ImmutableList.Builder typeConfigs = ImmutableList.builder();
        ConfigArray types = config.getArrayOrEmpty("type");
        for (int i = 0; i < types.size(); ++i) {
            typeConfigs.add((Object)TypeConfig.from(types.getTable(i), types.inputPositionOf(i), defaultTypeConfig));
        }
        builder.types((Iterable<? extends TypeConfig>)typeConfigs.build());
        builder.rejectLog(RejectLogConfig.from(config.getTableOrEmpty("rejectionLog")));
        ImmutableElasticsearchConfig result = builder.build();
        ElasticsearchConfig.warnIfConfigIsSuspect(result);
        return result;
    }

    private static void warnIfConfigIsSuspect(ElasticsearchConfig config) {
        boolean looksLikeElasticCloud;
        Logger log = LoggerFactory.getLogger(ElasticsearchConfig.class);
        String firstHostname = ((HttpHost)config.hosts().get(0)).getHostName();
        boolean looksLikeAws = firstHostname.endsWith(".es.amazonaws.com");
        if (looksLikeAws && config.aws().region().isEmpty()) {
            log.warn("It looks like you might be trying to connect to an Amazon OpenSearch Service domain. If so, please specify the domain's AWS region in the connector's [elasticsearch.aws] config section. If you are not connecting to an Amazon OpenSearch Service domain, please ignore this message.");
        }
        if ((looksLikeElasticCloud = firstHostname.endsWith(".cloud.es.io")) && !config.elasticCloud().enabled()) {
            log.warn("It looks like you might be trying to connect to an Elastic Cloud Elasticsearch endpoint. If so, please set 'enabled = true' in the connector's [elasticsearch.elasticCloud] config section, and use your Elastic Cloud API key as the password. If you are not connecting to an Elastic Cloud Elasticsearch endpoint, please ignore this message.");
        }
    }
}

