/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.es;

import com.couchbase.connector.config.es.AwsConfig;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AwsConfig", generator="Immutables")
@Immutable
public final class ImmutableAwsConfig
implements AwsConfig {
    private final String region;

    private ImmutableAwsConfig(String region) {
        this.region = region;
    }

    @Override
    public String region() {
        return this.region;
    }

    public final ImmutableAwsConfig withRegion(String value) {
        String newValue = Objects.requireNonNull(value, "region");
        if (this.region.equals(newValue)) {
            return this;
        }
        return new ImmutableAwsConfig(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAwsConfig && this.equalTo(0, (ImmutableAwsConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableAwsConfig another) {
        return this.region.equals(another.region);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.region.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AwsConfig").omitNullValues().add("region", (Object)this.region).toString();
    }

    public static ImmutableAwsConfig copyOf(AwsConfig instance) {
        if (instance instanceof ImmutableAwsConfig) {
            return (ImmutableAwsConfig)instance;
        }
        return ImmutableAwsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AwsConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REGION = 1L;
        private long initBits = 1L;
        @Nullable
        private String region;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AwsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.region(instance.region());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder region(String region) {
            this.region = Objects.requireNonNull(region, "region");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableAwsConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAwsConfig(this.region);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("region");
            }
            return "Cannot build AwsConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

