/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.es;

import com.couchbase.connector.config.StorageSize;
import com.couchbase.connector.config.es.BulkRequestConfig;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BulkRequestConfig", generator="Immutables")
@Immutable
public final class ImmutableBulkRequestConfig
implements BulkRequestConfig {
    private final int maxActions;
    private final StorageSize maxBytes;
    private final int concurrentRequests;
    private final Duration timeout;

    private ImmutableBulkRequestConfig(int maxActions, StorageSize maxBytes, int concurrentRequests, Duration timeout) {
        this.maxActions = maxActions;
        this.maxBytes = maxBytes;
        this.concurrentRequests = concurrentRequests;
        this.timeout = timeout;
    }

    @Override
    public int maxActions() {
        return this.maxActions;
    }

    @Override
    public StorageSize maxBytes() {
        return this.maxBytes;
    }

    @Override
    public int concurrentRequests() {
        return this.concurrentRequests;
    }

    @Override
    public Duration timeout() {
        return this.timeout;
    }

    public final ImmutableBulkRequestConfig withMaxActions(int value) {
        if (this.maxActions == value) {
            return this;
        }
        return ImmutableBulkRequestConfig.validate(new ImmutableBulkRequestConfig(value, this.maxBytes, this.concurrentRequests, this.timeout));
    }

    public final ImmutableBulkRequestConfig withMaxBytes(StorageSize value) {
        if (this.maxBytes == value) {
            return this;
        }
        StorageSize newValue = Objects.requireNonNull(value, "maxBytes");
        return ImmutableBulkRequestConfig.validate(new ImmutableBulkRequestConfig(this.maxActions, newValue, this.concurrentRequests, this.timeout));
    }

    public final ImmutableBulkRequestConfig withConcurrentRequests(int value) {
        if (this.concurrentRequests == value) {
            return this;
        }
        return ImmutableBulkRequestConfig.validate(new ImmutableBulkRequestConfig(this.maxActions, this.maxBytes, value, this.timeout));
    }

    public final ImmutableBulkRequestConfig withTimeout(Duration value) {
        if (this.timeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "timeout");
        return ImmutableBulkRequestConfig.validate(new ImmutableBulkRequestConfig(this.maxActions, this.maxBytes, this.concurrentRequests, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBulkRequestConfig && this.equalTo(0, (ImmutableBulkRequestConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableBulkRequestConfig another) {
        return this.maxActions == another.maxActions && this.maxBytes.equals(another.maxBytes) && this.concurrentRequests == another.concurrentRequests && this.timeout.equals(another.timeout);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.maxActions;
        h += (h << 5) + this.maxBytes.hashCode();
        h += (h << 5) + this.concurrentRequests;
        h += (h << 5) + this.timeout.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BulkRequestConfig").omitNullValues().add("maxActions", this.maxActions).add("maxBytes", (Object)this.maxBytes).add("concurrentRequests", this.concurrentRequests).add("timeout", (Object)this.timeout).toString();
    }

    private static ImmutableBulkRequestConfig validate(ImmutableBulkRequestConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableBulkRequestConfig copyOf(BulkRequestConfig instance) {
        if (instance instanceof ImmutableBulkRequestConfig) {
            return (ImmutableBulkRequestConfig)instance;
        }
        return ImmutableBulkRequestConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BulkRequestConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MAX_ACTIONS = 1L;
        private static final long INIT_BIT_MAX_BYTES = 2L;
        private static final long INIT_BIT_CONCURRENT_REQUESTS = 4L;
        private static final long INIT_BIT_TIMEOUT = 8L;
        private long initBits = 15L;
        private int maxActions;
        @Nullable
        private StorageSize maxBytes;
        private int concurrentRequests;
        @Nullable
        private Duration timeout;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BulkRequestConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.maxActions(instance.maxActions());
            this.maxBytes(instance.maxBytes());
            this.concurrentRequests(instance.concurrentRequests());
            this.timeout(instance.timeout());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxActions(int maxActions) {
            this.maxActions = maxActions;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxBytes(StorageSize maxBytes) {
            this.maxBytes = Objects.requireNonNull(maxBytes, "maxBytes");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder concurrentRequests(int concurrentRequests) {
            this.concurrentRequests = concurrentRequests;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeout(Duration timeout) {
            this.timeout = Objects.requireNonNull(timeout, "timeout");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableBulkRequestConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableBulkRequestConfig.validate(new ImmutableBulkRequestConfig(this.maxActions, this.maxBytes, this.concurrentRequests, this.timeout));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("maxActions");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxBytes");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("concurrentRequests");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("timeout");
            }
            return "Cannot build BulkRequestConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

