/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.es;

import com.couchbase.connector.config.common.CouchbaseConfig;
import com.couchbase.connector.config.common.GroupConfig;
import com.couchbase.connector.config.common.LoggingConfig;
import com.couchbase.connector.config.common.MetricsConfig;
import com.couchbase.connector.config.common.TrustStoreConfig;
import com.couchbase.connector.config.es.ConnectorConfig;
import com.couchbase.connector.config.es.ElasticsearchConfig;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConnectorConfig", generator="Immutables")
@Immutable
public final class ImmutableConnectorConfig
implements ConnectorConfig {
    private final CouchbaseConfig couchbase;
    private final ElasticsearchConfig elasticsearch;
    private final LoggingConfig logging;
    private final MetricsConfig metrics;
    private final GroupConfig group;
    @Nullable
    private final TrustStoreConfig trustStore;

    private ImmutableConnectorConfig(CouchbaseConfig couchbase, ElasticsearchConfig elasticsearch, LoggingConfig logging, MetricsConfig metrics, GroupConfig group, @Nullable TrustStoreConfig trustStore) {
        this.couchbase = couchbase;
        this.elasticsearch = elasticsearch;
        this.logging = logging;
        this.metrics = metrics;
        this.group = group;
        this.trustStore = trustStore;
    }

    @Override
    public CouchbaseConfig couchbase() {
        return this.couchbase;
    }

    @Override
    public ElasticsearchConfig elasticsearch() {
        return this.elasticsearch;
    }

    @Override
    public LoggingConfig logging() {
        return this.logging;
    }

    @Override
    public MetricsConfig metrics() {
        return this.metrics;
    }

    @Override
    public GroupConfig group() {
        return this.group;
    }

    @Override
    public Optional<TrustStoreConfig> trustStore() {
        return Optional.ofNullable(this.trustStore);
    }

    public final ImmutableConnectorConfig withCouchbase(CouchbaseConfig value) {
        if (this.couchbase == value) {
            return this;
        }
        CouchbaseConfig newValue = Objects.requireNonNull(value, "couchbase");
        return new ImmutableConnectorConfig(newValue, this.elasticsearch, this.logging, this.metrics, this.group, this.trustStore);
    }

    public final ImmutableConnectorConfig withElasticsearch(ElasticsearchConfig value) {
        if (this.elasticsearch == value) {
            return this;
        }
        ElasticsearchConfig newValue = Objects.requireNonNull(value, "elasticsearch");
        return new ImmutableConnectorConfig(this.couchbase, newValue, this.logging, this.metrics, this.group, this.trustStore);
    }

    public final ImmutableConnectorConfig withLogging(LoggingConfig value) {
        if (this.logging == value) {
            return this;
        }
        LoggingConfig newValue = Objects.requireNonNull(value, "logging");
        return new ImmutableConnectorConfig(this.couchbase, this.elasticsearch, newValue, this.metrics, this.group, this.trustStore);
    }

    public final ImmutableConnectorConfig withMetrics(MetricsConfig value) {
        if (this.metrics == value) {
            return this;
        }
        MetricsConfig newValue = Objects.requireNonNull(value, "metrics");
        return new ImmutableConnectorConfig(this.couchbase, this.elasticsearch, this.logging, newValue, this.group, this.trustStore);
    }

    public final ImmutableConnectorConfig withGroup(GroupConfig value) {
        if (this.group == value) {
            return this;
        }
        GroupConfig newValue = Objects.requireNonNull(value, "group");
        return new ImmutableConnectorConfig(this.couchbase, this.elasticsearch, this.logging, this.metrics, newValue, this.trustStore);
    }

    public final ImmutableConnectorConfig withTrustStore(TrustStoreConfig value) {
        TrustStoreConfig newValue = Objects.requireNonNull(value, "trustStore");
        if (this.trustStore == newValue) {
            return this;
        }
        return new ImmutableConnectorConfig(this.couchbase, this.elasticsearch, this.logging, this.metrics, this.group, newValue);
    }

    public final ImmutableConnectorConfig withTrustStore(Optional<? extends TrustStoreConfig> optional) {
        TrustStoreConfig value = optional.orElse(null);
        if (this.trustStore == value) {
            return this;
        }
        return new ImmutableConnectorConfig(this.couchbase, this.elasticsearch, this.logging, this.metrics, this.group, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConnectorConfig && this.equalTo(0, (ImmutableConnectorConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableConnectorConfig another) {
        return this.couchbase.equals(another.couchbase) && this.elasticsearch.equals(another.elasticsearch) && this.logging.equals(another.logging) && this.metrics.equals(another.metrics) && this.group.equals(another.group) && Objects.equals(this.trustStore, another.trustStore);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.couchbase.hashCode();
        h += (h << 5) + this.elasticsearch.hashCode();
        h += (h << 5) + this.logging.hashCode();
        h += (h << 5) + this.metrics.hashCode();
        h += (h << 5) + this.group.hashCode();
        h += (h << 5) + Objects.hashCode(this.trustStore);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConnectorConfig").omitNullValues().add("couchbase", (Object)this.couchbase).add("elasticsearch", (Object)this.elasticsearch).add("logging", (Object)this.logging).add("metrics", (Object)this.metrics).add("group", (Object)this.group).add("trustStore", (Object)this.trustStore).toString();
    }

    public static ImmutableConnectorConfig copyOf(ConnectorConfig instance) {
        if (instance instanceof ImmutableConnectorConfig) {
            return (ImmutableConnectorConfig)instance;
        }
        return ImmutableConnectorConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConnectorConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COUCHBASE = 1L;
        private static final long INIT_BIT_ELASTICSEARCH = 2L;
        private static final long INIT_BIT_LOGGING = 4L;
        private static final long INIT_BIT_METRICS = 8L;
        private static final long INIT_BIT_GROUP = 16L;
        private long initBits = 31L;
        @Nullable
        private CouchbaseConfig couchbase;
        @Nullable
        private ElasticsearchConfig elasticsearch;
        @Nullable
        private LoggingConfig logging;
        @Nullable
        private MetricsConfig metrics;
        @Nullable
        private GroupConfig group;
        @Nullable
        private TrustStoreConfig trustStore;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ConnectorConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.couchbase(instance.couchbase());
            this.elasticsearch(instance.elasticsearch());
            this.logging(instance.logging());
            this.metrics(instance.metrics());
            this.group(instance.group());
            Optional<TrustStoreConfig> trustStoreOptional = instance.trustStore();
            if (trustStoreOptional.isPresent()) {
                this.trustStore(trustStoreOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder couchbase(CouchbaseConfig couchbase) {
            this.couchbase = Objects.requireNonNull(couchbase, "couchbase");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder elasticsearch(ElasticsearchConfig elasticsearch) {
            this.elasticsearch = Objects.requireNonNull(elasticsearch, "elasticsearch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logging(LoggingConfig logging) {
            this.logging = Objects.requireNonNull(logging, "logging");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metrics(MetricsConfig metrics) {
            this.metrics = Objects.requireNonNull(metrics, "metrics");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder group(GroupConfig group) {
            this.group = Objects.requireNonNull(group, "group");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trustStore(TrustStoreConfig trustStore) {
            this.trustStore = Objects.requireNonNull(trustStore, "trustStore");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder trustStore(Optional<? extends TrustStoreConfig> trustStore) {
            this.trustStore = trustStore.orElse(null);
            return this;
        }

        public ImmutableConnectorConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConnectorConfig(this.couchbase, this.elasticsearch, this.logging, this.metrics, this.group, this.trustStore);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("couchbase");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("elasticsearch");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("logging");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("metrics");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("group");
            }
            return "Cannot build ConnectorConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

