/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.es;

import com.couchbase.connector.config.es.DocStructureConfig;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DocStructureConfig", generator="Immutables")
@Immutable
public final class ImmutableDocStructureConfig
implements DocStructureConfig {
    private final @Nullable String metadataFieldName;
    private final boolean documentContentAtTopLevel;
    private final boolean wrapCounters;

    private ImmutableDocStructureConfig(@Nullable String metadataFieldName, boolean documentContentAtTopLevel, boolean wrapCounters) {
        this.metadataFieldName = metadataFieldName;
        this.documentContentAtTopLevel = documentContentAtTopLevel;
        this.wrapCounters = wrapCounters;
    }

    @Override
    public @Nullable String metadataFieldName() {
        return this.metadataFieldName;
    }

    @Override
    public boolean documentContentAtTopLevel() {
        return this.documentContentAtTopLevel;
    }

    @Override
    public boolean wrapCounters() {
        return this.wrapCounters;
    }

    public final ImmutableDocStructureConfig withMetadataFieldName(@Nullable String value) {
        if (Objects.equals(this.metadataFieldName, value)) {
            return this;
        }
        return new ImmutableDocStructureConfig(value, this.documentContentAtTopLevel, this.wrapCounters);
    }

    public final ImmutableDocStructureConfig withDocumentContentAtTopLevel(boolean value) {
        if (this.documentContentAtTopLevel == value) {
            return this;
        }
        return new ImmutableDocStructureConfig(this.metadataFieldName, value, this.wrapCounters);
    }

    public final ImmutableDocStructureConfig withWrapCounters(boolean value) {
        if (this.wrapCounters == value) {
            return this;
        }
        return new ImmutableDocStructureConfig(this.metadataFieldName, this.documentContentAtTopLevel, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDocStructureConfig && this.equalTo(0, (ImmutableDocStructureConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableDocStructureConfig another) {
        return Objects.equals(this.metadataFieldName, another.metadataFieldName) && this.documentContentAtTopLevel == another.documentContentAtTopLevel && this.wrapCounters == another.wrapCounters;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.metadataFieldName);
        h += (h << 5) + Booleans.hashCode((boolean)this.documentContentAtTopLevel);
        h += (h << 5) + Booleans.hashCode((boolean)this.wrapCounters);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DocStructureConfig").omitNullValues().add("metadataFieldName", (Object)this.metadataFieldName).add("documentContentAtTopLevel", this.documentContentAtTopLevel).add("wrapCounters", this.wrapCounters).toString();
    }

    public static ImmutableDocStructureConfig copyOf(DocStructureConfig instance) {
        if (instance instanceof ImmutableDocStructureConfig) {
            return (ImmutableDocStructureConfig)instance;
        }
        return ImmutableDocStructureConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DocStructureConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DOCUMENT_CONTENT_AT_TOP_LEVEL = 1L;
        private static final long INIT_BIT_WRAP_COUNTERS = 2L;
        private long initBits = 3L;
        @javax.annotation.Nullable
        private @Nullable String metadataFieldName;
        private boolean documentContentAtTopLevel;
        private boolean wrapCounters;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DocStructureConfig instance) {
            Objects.requireNonNull(instance, "instance");
            @Nullable String metadataFieldNameValue = instance.metadataFieldName();
            if (metadataFieldNameValue != null) {
                this.metadataFieldName(metadataFieldNameValue);
            }
            this.documentContentAtTopLevel(instance.documentContentAtTopLevel());
            this.wrapCounters(instance.wrapCounters());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadataFieldName(@Nullable String metadataFieldName) {
            this.metadataFieldName = metadataFieldName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder documentContentAtTopLevel(boolean documentContentAtTopLevel) {
            this.documentContentAtTopLevel = documentContentAtTopLevel;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wrapCounters(boolean wrapCounters) {
            this.wrapCounters = wrapCounters;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDocStructureConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDocStructureConfig(this.metadataFieldName, this.documentContentAtTopLevel, this.wrapCounters);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("documentContentAtTopLevel");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("wrapCounters");
            }
            return "Cannot build DocStructureConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

