/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.es;

import com.couchbase.connector.config.common.ClientCertConfig;
import com.couchbase.connector.config.es.AwsConfig;
import com.couchbase.connector.config.es.BulkRequestConfig;
import com.couchbase.connector.config.es.DocStructureConfig;
import com.couchbase.connector.config.es.ElasticCloudConfig;
import com.couchbase.connector.config.es.ElasticsearchConfig;
import com.couchbase.connector.config.es.RejectLogConfig;
import com.couchbase.connector.config.es.TypeConfig;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.http.HttpHost;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ElasticsearchConfig", generator="Immutables")
@Immutable
public final class ImmutableElasticsearchConfig
implements ElasticsearchConfig {
    private final ImmutableList<HttpHost> hosts;
    private final String username;
    private final String password;
    private final boolean secureConnection;
    private final ImmutableList<X509Certificate> caCert;
    private final ClientCertConfig clientCert;
    private final BulkRequestConfig bulkRequest;
    private final DocStructureConfig docStructure;
    private final ImmutableList<TypeConfig> types;
    private final RejectLogConfig rejectLog;
    private final ElasticCloudConfig elasticCloud;
    private final AwsConfig aws;

    private ImmutableElasticsearchConfig(ImmutableList<HttpHost> hosts, String username, String password, boolean secureConnection, ImmutableList<X509Certificate> caCert, ClientCertConfig clientCert, BulkRequestConfig bulkRequest, DocStructureConfig docStructure, ImmutableList<TypeConfig> types, RejectLogConfig rejectLog, ElasticCloudConfig elasticCloud, AwsConfig aws) {
        this.hosts = hosts;
        this.username = username;
        this.password = password;
        this.secureConnection = secureConnection;
        this.caCert = caCert;
        this.clientCert = clientCert;
        this.bulkRequest = bulkRequest;
        this.docStructure = docStructure;
        this.types = types;
        this.rejectLog = rejectLog;
        this.elasticCloud = elasticCloud;
        this.aws = aws;
    }

    @Override
    public ImmutableList<HttpHost> hosts() {
        return this.hosts;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public boolean secureConnection() {
        return this.secureConnection;
    }

    public ImmutableList<X509Certificate> caCert() {
        return this.caCert;
    }

    @Override
    public ClientCertConfig clientCert() {
        return this.clientCert;
    }

    @Override
    public BulkRequestConfig bulkRequest() {
        return this.bulkRequest;
    }

    @Override
    public DocStructureConfig docStructure() {
        return this.docStructure;
    }

    @Override
    public ImmutableList<TypeConfig> types() {
        return this.types;
    }

    @Override
    public RejectLogConfig rejectLog() {
        return this.rejectLog;
    }

    @Override
    public ElasticCloudConfig elasticCloud() {
        return this.elasticCloud;
    }

    @Override
    public AwsConfig aws() {
        return this.aws;
    }

    public final ImmutableElasticsearchConfig withHosts(HttpHost ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig((ImmutableList<HttpHost>)newValue, this.username, this.password, this.secureConnection, this.caCert, this.clientCert, this.bulkRequest, this.docStructure, this.types, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withHosts(Iterable<? extends HttpHost> elements) {
        if (this.hosts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig((ImmutableList<HttpHost>)newValue, this.username, this.password, this.secureConnection, this.caCert, this.clientCert, this.bulkRequest, this.docStructure, this.types, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, newValue, this.password, this.secureConnection, this.caCert, this.clientCert, this.bulkRequest, this.docStructure, this.types, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, newValue, this.secureConnection, this.caCert, this.clientCert, this.bulkRequest, this.docStructure, this.types, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withSecureConnection(boolean value) {
        if (this.secureConnection == value) {
            return this;
        }
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, value, this.caCert, this.clientCert, this.bulkRequest, this.docStructure, this.types, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withCaCert(X509Certificate ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, this.secureConnection, (ImmutableList<X509Certificate>)newValue, this.clientCert, this.bulkRequest, this.docStructure, this.types, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withCaCert(Iterable<? extends X509Certificate> elements) {
        if (this.caCert == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, this.secureConnection, (ImmutableList<X509Certificate>)newValue, this.clientCert, this.bulkRequest, this.docStructure, this.types, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withClientCert(ClientCertConfig value) {
        if (this.clientCert == value) {
            return this;
        }
        ClientCertConfig newValue = Objects.requireNonNull(value, "clientCert");
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, this.secureConnection, this.caCert, newValue, this.bulkRequest, this.docStructure, this.types, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withBulkRequest(BulkRequestConfig value) {
        if (this.bulkRequest == value) {
            return this;
        }
        BulkRequestConfig newValue = Objects.requireNonNull(value, "bulkRequest");
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, this.secureConnection, this.caCert, this.clientCert, newValue, this.docStructure, this.types, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withDocStructure(DocStructureConfig value) {
        if (this.docStructure == value) {
            return this;
        }
        DocStructureConfig newValue = Objects.requireNonNull(value, "docStructure");
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, this.secureConnection, this.caCert, this.clientCert, this.bulkRequest, newValue, this.types, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withTypes(TypeConfig ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, this.secureConnection, this.caCert, this.clientCert, this.bulkRequest, this.docStructure, (ImmutableList<TypeConfig>)newValue, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withTypes(Iterable<? extends TypeConfig> elements) {
        if (this.types == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, this.secureConnection, this.caCert, this.clientCert, this.bulkRequest, this.docStructure, (ImmutableList<TypeConfig>)newValue, this.rejectLog, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withRejectLog(RejectLogConfig value) {
        if (this.rejectLog == value) {
            return this;
        }
        RejectLogConfig newValue = Objects.requireNonNull(value, "rejectLog");
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, this.secureConnection, this.caCert, this.clientCert, this.bulkRequest, this.docStructure, this.types, newValue, this.elasticCloud, this.aws));
    }

    public final ImmutableElasticsearchConfig withElasticCloud(ElasticCloudConfig value) {
        if (this.elasticCloud == value) {
            return this;
        }
        ElasticCloudConfig newValue = Objects.requireNonNull(value, "elasticCloud");
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, this.secureConnection, this.caCert, this.clientCert, this.bulkRequest, this.docStructure, this.types, this.rejectLog, newValue, this.aws));
    }

    public final ImmutableElasticsearchConfig withAws(AwsConfig value) {
        if (this.aws == value) {
            return this;
        }
        AwsConfig newValue = Objects.requireNonNull(value, "aws");
        return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig(this.hosts, this.username, this.password, this.secureConnection, this.caCert, this.clientCert, this.bulkRequest, this.docStructure, this.types, this.rejectLog, this.elasticCloud, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableElasticsearchConfig && this.equalTo(0, (ImmutableElasticsearchConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableElasticsearchConfig another) {
        return this.hosts.equals(another.hosts) && this.username.equals(another.username) && this.password.equals(another.password) && this.secureConnection == another.secureConnection && this.caCert.equals(another.caCert) && this.clientCert.equals(another.clientCert) && this.bulkRequest.equals(another.bulkRequest) && this.docStructure.equals(another.docStructure) && this.types.equals(another.types) && this.rejectLog.equals(another.rejectLog) && this.elasticCloud.equals(another.elasticCloud) && this.aws.equals(another.aws);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hosts.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.password.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.secureConnection);
        h += (h << 5) + this.caCert.hashCode();
        h += (h << 5) + this.clientCert.hashCode();
        h += (h << 5) + this.bulkRequest.hashCode();
        h += (h << 5) + this.docStructure.hashCode();
        h += (h << 5) + this.types.hashCode();
        h += (h << 5) + this.rejectLog.hashCode();
        h += (h << 5) + this.elasticCloud.hashCode();
        h += (h << 5) + this.aws.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ElasticsearchConfig").omitNullValues().add("hosts", this.hosts).add("username", (Object)this.username).add("secureConnection", this.secureConnection).add("clientCert", (Object)this.clientCert).add("bulkRequest", (Object)this.bulkRequest).add("docStructure", (Object)this.docStructure).add("types", this.types).add("rejectLog", (Object)this.rejectLog).add("elasticCloud", (Object)this.elasticCloud).add("aws", (Object)this.aws).toString();
    }

    private static ImmutableElasticsearchConfig validate(ImmutableElasticsearchConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableElasticsearchConfig copyOf(ElasticsearchConfig instance) {
        if (instance instanceof ImmutableElasticsearchConfig) {
            return (ImmutableElasticsearchConfig)instance;
        }
        return ImmutableElasticsearchConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ElasticsearchConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private static final long INIT_BIT_SECURE_CONNECTION = 4L;
        private static final long INIT_BIT_CLIENT_CERT = 8L;
        private static final long INIT_BIT_BULK_REQUEST = 16L;
        private static final long INIT_BIT_DOC_STRUCTURE = 32L;
        private static final long INIT_BIT_REJECT_LOG = 64L;
        private static final long INIT_BIT_ELASTIC_CLOUD = 128L;
        private static final long INIT_BIT_AWS = 256L;
        private long initBits = 511L;
        private ImmutableList.Builder<HttpHost> hosts = ImmutableList.builder();
        @Nullable
        private String username;
        @Nullable
        private String password;
        private boolean secureConnection;
        private ImmutableList.Builder<X509Certificate> caCert = ImmutableList.builder();
        @Nullable
        private ClientCertConfig clientCert;
        @Nullable
        private BulkRequestConfig bulkRequest;
        @Nullable
        private DocStructureConfig docStructure;
        private ImmutableList.Builder<TypeConfig> types = ImmutableList.builder();
        @Nullable
        private RejectLogConfig rejectLog;
        @Nullable
        private ElasticCloudConfig elasticCloud;
        @Nullable
        private AwsConfig aws;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ElasticsearchConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllHosts((Iterable<? extends HttpHost>)instance.hosts());
            this.username(instance.username());
            this.password(instance.password());
            this.secureConnection(instance.secureConnection());
            this.addAllCaCert(instance.caCert());
            this.clientCert(instance.clientCert());
            this.bulkRequest(instance.bulkRequest());
            this.docStructure(instance.docStructure());
            this.addAllTypes((Iterable<? extends TypeConfig>)instance.types());
            this.rejectLog(instance.rejectLog());
            this.elasticCloud(instance.elasticCloud());
            this.aws(instance.aws());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHosts(HttpHost element) {
            this.hosts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHosts(HttpHost ... elements) {
            this.hosts.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hosts(Iterable<? extends HttpHost> elements) {
            this.hosts = ImmutableList.builder();
            return this.addAllHosts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllHosts(Iterable<? extends HttpHost> elements) {
            this.hosts.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder secureConnection(boolean secureConnection) {
            this.secureConnection = secureConnection;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCaCert(X509Certificate element) {
            this.caCert.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCaCert(X509Certificate ... elements) {
            this.caCert.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder caCert(Iterable<? extends X509Certificate> elements) {
            this.caCert = ImmutableList.builder();
            return this.addAllCaCert(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCaCert(Iterable<? extends X509Certificate> elements) {
            this.caCert.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientCert(ClientCertConfig clientCert) {
            this.clientCert = Objects.requireNonNull(clientCert, "clientCert");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bulkRequest(BulkRequestConfig bulkRequest) {
            this.bulkRequest = Objects.requireNonNull(bulkRequest, "bulkRequest");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder docStructure(DocStructureConfig docStructure) {
            this.docStructure = Objects.requireNonNull(docStructure, "docStructure");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTypes(TypeConfig element) {
            this.types.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTypes(TypeConfig ... elements) {
            this.types.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder types(Iterable<? extends TypeConfig> elements) {
            this.types = ImmutableList.builder();
            return this.addAllTypes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTypes(Iterable<? extends TypeConfig> elements) {
            this.types.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rejectLog(RejectLogConfig rejectLog) {
            this.rejectLog = Objects.requireNonNull(rejectLog, "rejectLog");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder elasticCloud(ElasticCloudConfig elasticCloud) {
            this.elasticCloud = Objects.requireNonNull(elasticCloud, "elasticCloud");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder aws(AwsConfig aws) {
            this.aws = Objects.requireNonNull(aws, "aws");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public ImmutableElasticsearchConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableElasticsearchConfig.validate(new ImmutableElasticsearchConfig((ImmutableList<HttpHost>)this.hosts.build(), this.username, this.password, this.secureConnection, (ImmutableList<X509Certificate>)this.caCert.build(), this.clientCert, this.bulkRequest, this.docStructure, (ImmutableList<TypeConfig>)this.types.build(), this.rejectLog, this.elasticCloud, this.aws));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("secureConnection");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("clientCert");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("bulkRequest");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("docStructure");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("rejectLog");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("elasticCloud");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("aws");
            }
            return "Cannot build ElasticsearchConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

