/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.es;

import com.couchbase.connector.config.es.TypeConfig;
import com.couchbase.connector.config.toml.ConfigPosition;
import com.fasterxml.jackson.core.JsonPointer;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TypeConfig", generator="Immutables")
@Immutable
public final class ImmutableTypeConfig
implements TypeConfig {
    private final @Nullable String index;
    private final @Nullable String pipeline;
    private final @Nullable JsonPointer routing;
    private final boolean ignore;
    private final boolean ignoreDeletes;
    private final boolean matchOnQualifiedKey;
    private final TypeConfig.IndexMatcher matcher;
    private final @Nullable ConfigPosition position;

    private ImmutableTypeConfig(@Nullable String index, @Nullable String pipeline, @Nullable JsonPointer routing, boolean ignore, boolean ignoreDeletes, boolean matchOnQualifiedKey, TypeConfig.IndexMatcher matcher, @Nullable ConfigPosition position) {
        this.index = index;
        this.pipeline = pipeline;
        this.routing = routing;
        this.ignore = ignore;
        this.ignoreDeletes = ignoreDeletes;
        this.matchOnQualifiedKey = matchOnQualifiedKey;
        this.matcher = matcher;
        this.position = position;
    }

    @Override
    public @Nullable String index() {
        return this.index;
    }

    @Override
    public @Nullable String pipeline() {
        return this.pipeline;
    }

    @Override
    public @Nullable JsonPointer routing() {
        return this.routing;
    }

    @Override
    public boolean ignore() {
        return this.ignore;
    }

    @Override
    public boolean ignoreDeletes() {
        return this.ignoreDeletes;
    }

    @Override
    public boolean matchOnQualifiedKey() {
        return this.matchOnQualifiedKey;
    }

    @Override
    public TypeConfig.IndexMatcher matcher() {
        return this.matcher;
    }

    @Override
    public @Nullable ConfigPosition position() {
        return this.position;
    }

    public final ImmutableTypeConfig withIndex(@Nullable String value) {
        if (Objects.equals(this.index, value)) {
            return this;
        }
        return ImmutableTypeConfig.validate(new ImmutableTypeConfig(value, this.pipeline, this.routing, this.ignore, this.ignoreDeletes, this.matchOnQualifiedKey, this.matcher, this.position));
    }

    public final ImmutableTypeConfig withPipeline(@Nullable String value) {
        if (Objects.equals(this.pipeline, value)) {
            return this;
        }
        return ImmutableTypeConfig.validate(new ImmutableTypeConfig(this.index, value, this.routing, this.ignore, this.ignoreDeletes, this.matchOnQualifiedKey, this.matcher, this.position));
    }

    public final ImmutableTypeConfig withRouting(@Nullable JsonPointer value) {
        if (this.routing == value) {
            return this;
        }
        return ImmutableTypeConfig.validate(new ImmutableTypeConfig(this.index, this.pipeline, value, this.ignore, this.ignoreDeletes, this.matchOnQualifiedKey, this.matcher, this.position));
    }

    public final ImmutableTypeConfig withIgnore(boolean value) {
        if (this.ignore == value) {
            return this;
        }
        return ImmutableTypeConfig.validate(new ImmutableTypeConfig(this.index, this.pipeline, this.routing, value, this.ignoreDeletes, this.matchOnQualifiedKey, this.matcher, this.position));
    }

    public final ImmutableTypeConfig withIgnoreDeletes(boolean value) {
        if (this.ignoreDeletes == value) {
            return this;
        }
        return ImmutableTypeConfig.validate(new ImmutableTypeConfig(this.index, this.pipeline, this.routing, this.ignore, value, this.matchOnQualifiedKey, this.matcher, this.position));
    }

    public final ImmutableTypeConfig withMatchOnQualifiedKey(boolean value) {
        if (this.matchOnQualifiedKey == value) {
            return this;
        }
        return ImmutableTypeConfig.validate(new ImmutableTypeConfig(this.index, this.pipeline, this.routing, this.ignore, this.ignoreDeletes, value, this.matcher, this.position));
    }

    public final ImmutableTypeConfig withMatcher(TypeConfig.IndexMatcher value) {
        if (this.matcher == value) {
            return this;
        }
        TypeConfig.IndexMatcher newValue = Objects.requireNonNull(value, "matcher");
        return ImmutableTypeConfig.validate(new ImmutableTypeConfig(this.index, this.pipeline, this.routing, this.ignore, this.ignoreDeletes, this.matchOnQualifiedKey, newValue, this.position));
    }

    public final ImmutableTypeConfig withPosition(@Nullable ConfigPosition value) {
        if (this.position == value) {
            return this;
        }
        return ImmutableTypeConfig.validate(new ImmutableTypeConfig(this.index, this.pipeline, this.routing, this.ignore, this.ignoreDeletes, this.matchOnQualifiedKey, this.matcher, value));
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTypeConfig && this.equalTo(0, (ImmutableTypeConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableTypeConfig another) {
        return Objects.equals(this.index, another.index) && Objects.equals(this.pipeline, another.pipeline) && Objects.equals(this.routing, another.routing) && this.ignore == another.ignore && this.ignoreDeletes == another.ignoreDeletes && this.matchOnQualifiedKey == another.matchOnQualifiedKey && this.matcher.equals(another.matcher);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.index);
        h += (h << 5) + Objects.hashCode(this.pipeline);
        h += (h << 5) + Objects.hashCode(this.routing);
        h += (h << 5) + Booleans.hashCode((boolean)this.ignore);
        h += (h << 5) + Booleans.hashCode((boolean)this.ignoreDeletes);
        h += (h << 5) + Booleans.hashCode((boolean)this.matchOnQualifiedKey);
        h += (h << 5) + this.matcher.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TypeConfig").omitNullValues().add("index", (Object)this.index).add("pipeline", (Object)this.pipeline).add("routing", (Object)this.routing).add("ignore", this.ignore).add("ignoreDeletes", this.ignoreDeletes).add("matchOnQualifiedKey", this.matchOnQualifiedKey).add("matcher", (Object)this.matcher).toString();
    }

    private static ImmutableTypeConfig validate(ImmutableTypeConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableTypeConfig copyOf(TypeConfig instance) {
        if (instance instanceof ImmutableTypeConfig) {
            return (ImmutableTypeConfig)instance;
        }
        return ImmutableTypeConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TypeConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IGNORE = 1L;
        private static final long INIT_BIT_IGNORE_DELETES = 2L;
        private static final long INIT_BIT_MATCH_ON_QUALIFIED_KEY = 4L;
        private static final long INIT_BIT_MATCHER = 8L;
        private long initBits = 15L;
        @javax.annotation.Nullable
        private @Nullable String index;
        @javax.annotation.Nullable
        private @Nullable String pipeline;
        @javax.annotation.Nullable
        private @Nullable JsonPointer routing;
        private boolean ignore;
        private boolean ignoreDeletes;
        private boolean matchOnQualifiedKey;
        @javax.annotation.Nullable
        private TypeConfig.IndexMatcher matcher;
        @javax.annotation.Nullable
        private @Nullable ConfigPosition position;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TypeConfig instance) {
            JsonPointer routingValue;
            String pipelineValue;
            Objects.requireNonNull(instance, "instance");
            @Nullable String indexValue = instance.index();
            if (indexValue != null) {
                this.index(indexValue);
            }
            if ((pipelineValue = instance.pipeline()) != null) {
                this.pipeline(pipelineValue);
            }
            if ((routingValue = instance.routing()) != null) {
                this.routing(routingValue);
            }
            this.ignore(instance.ignore());
            this.ignoreDeletes(instance.ignoreDeletes());
            this.matchOnQualifiedKey(instance.matchOnQualifiedKey());
            this.matcher(instance.matcher());
            @Nullable ConfigPosition positionValue = instance.position();
            if (positionValue != null) {
                this.position(positionValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(@Nullable String index) {
            this.index = index;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pipeline(@Nullable String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder routing(@Nullable JsonPointer routing) {
            this.routing = routing;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ignore(boolean ignore) {
            this.ignore = ignore;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ignoreDeletes(boolean ignoreDeletes) {
            this.ignoreDeletes = ignoreDeletes;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder matchOnQualifiedKey(boolean matchOnQualifiedKey) {
            this.matchOnQualifiedKey = matchOnQualifiedKey;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder matcher(TypeConfig.IndexMatcher matcher) {
            this.matcher = Objects.requireNonNull(matcher, "matcher");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder position(@Nullable ConfigPosition position) {
            this.position = position;
            return this;
        }

        public ImmutableTypeConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableTypeConfig.validate(new ImmutableTypeConfig(this.index, this.pipeline, this.routing, this.ignore, this.ignoreDeletes, this.matchOnQualifiedKey, this.matcher, this.position));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ignore");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ignoreDeletes");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("matchOnQualifiedKey");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("matcher");
            }
            return "Cannot build TypeConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

