/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.es;

import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.ConfigHelper;
import com.couchbase.connector.config.es.ImmutableTypeConfig;
import com.couchbase.connector.config.toml.ConfigPosition;
import com.couchbase.connector.config.toml.ConfigTable;
import com.couchbase.connector.dcp.Event;
import com.fasterxml.jackson.core.JsonPointer;
import com.google.common.base.Strings;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.immutables.value.Value;
import org.jspecify.annotations.Nullable;

@Value.Immutable
public interface TypeConfig {
    public @Nullable String index();

    public @Nullable String pipeline();

    public @Nullable JsonPointer routing();

    public boolean ignore();

    public boolean ignoreDeletes();

    public boolean matchOnQualifiedKey();

    public IndexMatcher matcher();

    @Value.Auxiliary
    public @Nullable ConfigPosition position();

    @Value.Check
    default public void check() {
        if (!this.ignore() && this.index() == null && !(this.matcher() instanceof IdRegexInferredIndexMatcher)) {
            throw new ConfigException("Missing 'index' (or 'regex' with capturing group named 'index') for config at " + String.valueOf(this.position()));
        }
    }

    public static ImmutableTypeConfig from(ConfigTable config, ConfigPosition position, TypeConfig defaults) {
        config.expectOnly("typeName", "index", "pipeline", "routing", "ignore", "ignoreDeletes", "prefix", "regex", "matchOnQualifiedKey");
        ConfigHelper.warnIfDeprecatedTypeNameIsPresent(config);
        String index = Strings.emptyToNull((String)config.getString("index").orElseGet(defaults::index));
        String routing = Strings.emptyToNull((String)config.getString("routing").orElse(null));
        boolean qualifiedKey = config.getBoolean("matchOnQualifiedKey").orElseGet(defaults::matchOnQualifiedKey);
        ImmutableTypeConfig.Builder builder = ImmutableTypeConfig.builder().position(position).index(index).matchOnQualifiedKey(qualifiedKey).routing(TypeConfig.parseRouting(routing, config.inputPositionOf("routing"))).pipeline(Strings.emptyToNull((String)config.getString("pipeline").orElseGet(defaults::pipeline))).ignoreDeletes(config.getBoolean("ignoreDeletes").orElseGet(defaults::ignoreDeletes)).ignore(config.getBoolean("ignore").orElseGet(defaults::ignore));
        String idPrefix = config.getString("prefix").orElse(null);
        String idRegex = config.getString("regex").orElse(null);
        if (idPrefix != null && idRegex != null) {
            throw new ConfigException("Type at " + String.valueOf(position) + " can have 'prefix' or 'regex', but not both.");
        }
        if (idPrefix == null && idRegex == null) {
            throw new ConfigException("Type at " + String.valueOf(position) + " must have 'prefix' or 'regex'.");
        }
        if (idPrefix != null) {
            builder.matcher(new IdPrefixMatcher(index, idPrefix, qualifiedKey));
        } else {
            try {
                if (idRegex.contains("(?<index>")) {
                    if (config.getString("index").isPresent()) {
                        throw new ConfigException("Type at " + String.valueOf(position) + " must not have 'index' because it's inferred from named capturing group in 'regex'.");
                    }
                    builder.matcher(new IdRegexInferredIndexMatcher(idRegex, qualifiedKey));
                } else {
                    builder.matcher(new IdRegexMatcher(index, idRegex, qualifiedKey));
                }
            }
            catch (PatternSyntaxException e) {
                throw new ConfigException("Invalid regex '" + idRegex + "' at " + String.valueOf(config.inputPositionOf("regex")) + " -- " + e.getMessage());
            }
        }
        ImmutableTypeConfig type = builder.build();
        if (type.routing() != null && !type.ignoreDeletes()) {
            throw new ConfigException("Custom 'routing' requires 'ignoreDeletes = true' for type at " + String.valueOf(position) + ". (Due to limitations in the current implementation, routing information is not available to the connector when documents are deleted, so it's not possible to route the deletion request to the correct Elasticsearch shard.)");
        }
        return type;
    }

    public static JsonPointer parseRouting(String routing, ConfigPosition position) {
        try {
            return routing == null ? null : JsonPointer.compile((String)routing);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Invalid 'routing' JSON pointer at " + String.valueOf(position) + " ; " + e.getMessage());
        }
    }

    public static class IdRegexInferredIndexMatcher
    implements IndexMatcher {
        private final Pattern pattern;
        private final boolean qualifiedKey;

        public IdRegexInferredIndexMatcher(String pattern, boolean qualifiedKey) {
            this.pattern = Pattern.compile(pattern);
            this.qualifiedKey = qualifiedKey;
        }

        @Override
        public String getIndexIfMatches(Event event) {
            Matcher m = this.pattern.matcher(event.getKey(this.qualifiedKey));
            return m.matches() ? this.sanitizeIndexName(m.group("index")) : null;
        }

        private String sanitizeIndexName(String index) {
            if (((String)index).startsWith("_") || ((String)index).startsWith("-")) {
                index = "@" + ((String)index).substring(1);
            }
            return ((String)index).toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return "regex='" + String.valueOf(this.pattern) + "'; qualifiedKey=" + this.qualifiedKey;
        }
    }

    public static class IdRegexMatcher
    implements IndexMatcher {
        private final String index;
        private final Pattern pattern;
        private final boolean qualifiedKey;

        public IdRegexMatcher(String index, String pattern, boolean qualifiedKey) {
            this.index = index;
            this.pattern = Pattern.compile(pattern);
            this.qualifiedKey = qualifiedKey;
        }

        @Override
        public String getIndexIfMatches(Event event) {
            return this.pattern.matcher(event.getKey(this.qualifiedKey)).matches() ? this.index : null;
        }

        public String toString() {
            return "regex='" + String.valueOf(this.pattern) + "'; qualifiedKey=" + this.qualifiedKey;
        }
    }

    public static class IdPrefixMatcher
    implements IndexMatcher {
        private final String prefix;
        private final String index;
        private final boolean qualifiedKey;

        public IdPrefixMatcher(String index, String prefix, boolean qualifiedKey) {
            this.index = index;
            this.prefix = Objects.requireNonNull(prefix);
            this.qualifiedKey = qualifiedKey;
        }

        @Override
        public String getIndexIfMatches(Event event) {
            return event.getKey(this.qualifiedKey).startsWith(this.prefix) ? this.index : null;
        }

        public String toString() {
            return "prefix='" + this.prefix + "'; qualifiedKey=" + this.qualifiedKey;
        }
    }

    public static interface IndexMatcher {
        public String getIndexIfMatches(Event var1);
    }
}

