/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.config.toml;

import com.couchbase.connector.config.ConfigException;
import com.couchbase.connector.config.toml.ConfigArray;
import com.couchbase.connector.config.toml.ConfigPosition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tuweni.toml.TomlArray;
import org.apache.tuweni.toml.TomlPosition;
import org.apache.tuweni.toml.TomlTable;

public class ConfigTable {
    private final TomlTable wrapped;

    public ConfigTable(TomlTable wrapped) {
        this.wrapped = Objects.requireNonNull(wrapped);
    }

    public ConfigTable getTableOrEmpty(String key) {
        return new ConfigTable(this.wrapped.getTableOrEmpty(key));
    }

    public ConfigArray getArrayOrEmpty(String key) {
        return new ConfigArray(this.wrapped.getArrayOrEmpty(key));
    }

    public Set<String> dottedKeySet() {
        return this.wrapped.dottedKeySet();
    }

    public ConfigPosition inputPositionOf(String key) {
        TomlPosition pos = this.wrapped.inputPositionOf(key);
        return pos == null ? null : new ConfigPosition(pos);
    }

    public Optional<?> get(String key) {
        return Optional.ofNullable(this.wrapped.get(key));
    }

    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    public Optional<String> getString(String key) {
        return Optional.ofNullable(this.wrapped.getString(key));
    }

    public String getRequiredString(String key) {
        return this.getString(key).orElseThrow(() -> new ConfigException("missing '" + key + "' config property"));
    }

    public boolean getRequiredBoolean(String key) {
        return this.getBoolean(key).orElseThrow(() -> new ConfigException("missing '" + key + "' config property"));
    }

    public Optional<Boolean> getBoolean(String key) {
        try {
            return Optional.ofNullable(this.wrapped.getBoolean(key));
        }
        catch (Exception e) {
            return this.getString(key).map(v -> {
                switch (v) {
                    case "true": {
                        return Boolean.TRUE;
                    }
                    case "false": {
                        return Boolean.FALSE;
                    }
                }
                throw new ConfigException("Value of '" + key + "' could not be parsed as an boolean (must be 'true' or 'false' but got '" + v + "')");
            });
        }
    }

    public Optional<Integer> getInt(String key) {
        return this.getIntInRange(key, 1, Integer.MAX_VALUE);
    }

    public Optional<Long> getLong(String key) {
        try {
            return Optional.ofNullable(this.wrapped.getLong(key));
        }
        catch (Exception e) {
            try {
                return this.getString(key).map(Long::valueOf);
            }
            catch (NumberFormatException n) {
                throw new ConfigException("Value of '" + key + "' could not be parsed as an integer; " + String.valueOf(n));
            }
        }
    }

    public <T extends Enum<T>> Optional<T> getEnum(String keyName, Class<T> enumClass) {
        String s = this.wrapped.getString(keyName);
        if (s == null || s.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Enum.valueOf(enumClass, s));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("Unrecognized value '" + s + "' for '" + keyName + "' at " + String.valueOf(this.inputPositionOf(keyName)) + "; expected one of " + Arrays.toString(enumClass.getEnumConstants()));
        }
    }

    public Optional<Integer> getIntInRange(String key, int min, int max) {
        Long result = this.getLong(key).orElse(null);
        if (result == null) {
            return Optional.empty();
        }
        if (result > (long)max) {
            throw new ConfigException("Value for '" + key + "' at " + String.valueOf(this.inputPositionOf(key)) + " may not be larger than " + max);
        }
        if (result < (long)min) {
            throw new ConfigException("Value for '" + key + "' at " + String.valueOf(this.inputPositionOf(key)) + " may not be smaller than " + min);
        }
        return Optional.of(result.intValue());
    }

    public void expectOnly(String ... recognizedKeys) {
        HashSet<String> recognized = new HashSet<String>(Arrays.asList(recognizedKeys));
        Set present = this.wrapped.keySet();
        Sets.SetView unrecognized = Sets.difference((Set)present, recognized);
        if (!unrecognized.isEmpty()) {
            String key = (String)unrecognized.iterator().next();
            throw new ConfigException("Unrecognized item '" + key + "' at " + String.valueOf(this.inputPositionOf(key)) + "; expected items in this context are: " + Arrays.toString(recognizedKeys));
        }
    }

    public void require(String parent, String ... requiredKeys) {
        Set present;
        HashSet<String> required = new HashSet<String>(Arrays.asList(requiredKeys));
        Sets.SetView missing = Sets.difference(required, (Set)(present = this.wrapped.keySet()));
        if (!missing.isEmpty()) {
            String key = (String)missing.iterator().next();
            throw new ConfigException("Missing config property '" + key + "' for " + parent + "; required items in this context are: " + Arrays.toString(requiredKeys));
        }
    }

    public <R> List<R> getOptionalList(String name, Function<String, R> transformer) {
        TomlArray array = this.wrapped.getArray(name);
        if (array == null) {
            return ImmutableList.of();
        }
        try {
            return ImmutableList.copyOf((Collection)array.toList().stream().map(String.class::cast).map(transformer).collect(Collectors.toList()));
        }
        catch (ClassCastException e) {
            throw new ConfigException("Array '" + name + "' may only contain strings");
        }
        catch (RuntimeException e) {
            throw new ConfigException("Failed to parse array '" + name + "'; " + e.getMessage());
        }
    }

    public List<String> getRequiredStrings(String name) {
        List<String> results = this.getOptionalList(name, Function.identity());
        if (results.isEmpty()) {
            throw new ConfigException("Config key '" + name + "' must be present, and must have at least one value.");
        }
        return results;
    }
}

