/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.dcp;

import com.couchbase.connector.dcp.SnapshotMarker;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class Checkpoint {
    private final long vbuuid;
    private final long seqno;
    private final SnapshotMarker snapshot;
    public static final Checkpoint ZERO = new Checkpoint(0L, 0L, new SnapshotMarker(0L, 0L));

    public Checkpoint(@JsonProperty(value="vbuuid") long vbuuid, @JsonProperty(value="seqno") long seqno, @JsonProperty(value="snapshot") SnapshotMarker snapshot) {
        this.vbuuid = vbuuid;
        this.seqno = seqno;
        this.snapshot = Objects.requireNonNull(snapshot);
    }

    public long getVbuuid() {
        return this.vbuuid;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public SnapshotMarker getSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        return this.vbuuid + "@" + this.seqno + String.valueOf(this.snapshot);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checkpoint that = (Checkpoint)o;
        if (this.vbuuid != that.vbuuid) {
            return false;
        }
        if (this.seqno != that.seqno) {
            return false;
        }
        return this.snapshot.equals(that.snapshot);
    }

    public int hashCode() {
        int result = (int)(this.vbuuid ^ this.vbuuid >>> 32);
        result = 31 * result + (int)(this.seqno ^ this.seqno >>> 32);
        return result;
    }
}

