/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connector.dcp;

import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.TemporaryFailureException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.codec.RawBinaryTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.UpsertOptions;
import com.couchbase.connector.dcp.Checkpoint;
import com.couchbase.connector.dcp.CheckpointDao;
import com.couchbase.connector.dcp.CouchbaseHelper;
import com.couchbase.connector.dcp.DcpHelper;
import com.couchbase.connector.elasticsearch.io.BackoffPolicyBuilder;
import com.couchbase.connector.elasticsearch.io.MoreBackoffPolicies;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseCheckpointDao
implements CheckpointDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseCheckpointDao.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Collection collection;
    private final String[] checkpointDocumentKeys;
    private static final String XATTR_NAME = "cbes";

    public CouchbaseCheckpointDao(Collection collection, String groupName) {
        this.collection = Objects.requireNonNull(collection);
        int numPartitions = CouchbaseHelper.getNumPartitions(collection);
        String keyPrefix = DcpHelper.metadataDocumentIdPrefix() + groupName + ":checkpoint:";
        this.checkpointDocumentKeys = new String[numPartitions];
        for (int partition = 0; partition < numPartitions; ++partition) {
            String baseKey = keyPrefix + partition;
            this.checkpointDocumentKeys[partition] = CouchbaseHelper.forceKeyToPartition(baseKey, partition, numPartitions).orElse(baseKey);
        }
    }

    @Override
    public void save(String bucketUuid, Map<Integer, Checkpoint> vbucketToCheckpoint) {
        RuntimeException deferredException = null;
        Iterator retryDelays = new BackoffPolicyBuilder(MoreBackoffPolicies.truncatedExponentialBackoff(Duration.ofMillis(50L), Duration.ofSeconds(5L))).fullJitter().timeout(Duration.ofSeconds(5L)).build().iterator();
        block5: for (Map.Entry<Integer, Checkpoint> entry : vbucketToCheckpoint.entrySet()) {
            int vbucket = entry.getKey();
            Checkpoint checkpoint = entry.getValue();
            if (checkpoint == null) continue;
            try {
                HashMap<String, Object> document = new HashMap<String, Object>();
                document.put("bucketUuid", bucketUuid);
                document.put("checkpoint", checkpoint);
                while (true) {
                    try {
                        this.createDocument(this.documentIdForVbucket(vbucket), document);
                        continue block5;
                    }
                    catch (TemporaryFailureException e) {
                        if (!retryDelays.hasNext()) {
                            throw e;
                        }
                        Duration retryDelay = (Duration)retryDelays.next();
                        LOGGER.info("Temporary failure saving checkpoint for vbucket {}, retying in {}", (Object)vbucket, (Object)retryDelay);
                        TimeUnit.MILLISECONDS.sleep(retryDelay.toMillis());
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to save checkpoint for vbucket {}", (Object)vbucket);
                if (deferredException != null) continue;
                deferredException = new RuntimeException(e);
            }
        }
        if (deferredException != null) {
            throw deferredException;
        }
    }

    private void upsertXattrs(String documentId, Map<String, Object> content) {
        this.collection.mutateIn(documentId, Collections.singletonList(MutateInSpec.upsert((String)XATTR_NAME, content).xattr()));
    }

    private void createDocument(String documentId, Map<String, Object> content) {
        try {
            this.upsertXattrs(documentId, content);
        }
        catch (DocumentNotFoundException e) {
            this.collection.upsert(documentId, (Object)ArrayUtils.EMPTY_BYTE_ARRAY, UpsertOptions.upsertOptions().transcoder((Transcoder)RawBinaryTranscoder.INSTANCE));
            this.upsertXattrs(documentId, content);
        }
    }

    private String documentIdForVbucket(int vbucket) {
        return this.checkpointDocumentKeys[vbucket];
    }

    @Override
    public void clear(String bucketUuid, Set<Integer> vbuckets) {
        for (int vbucket : vbuckets) {
            try {
                this.collection.remove(this.documentIdForVbucket(vbucket));
            }
            catch (DocumentNotFoundException documentNotFoundException) {}
        }
    }

    @Override
    public Map<Integer, Checkpoint> loadExisting(String bucketUuid, Set<Integer> vbuckets) {
        LinkedHashMap<Integer, Checkpoint> result = new LinkedHashMap<Integer, Checkpoint>();
        for (int vbucket : vbuckets) {
            JsonNode content = this.readCheckpointForPartition(vbucket);
            if (content == null) continue;
            Checkpoint checkpoint = (Checkpoint)mapper.convertValue((Object)content.get("checkpoint"), Checkpoint.class);
            result.put(vbucket, checkpoint);
        }
        return result;
    }

    private @Nullable JsonNode readCheckpointForPartition(int partition) {
        try {
            String documentId = this.documentIdForVbucket(partition);
            LookupInResult lookup = this.collection.lookupIn(documentId, Collections.singletonList(LookupInSpec.get((String)XATTR_NAME).xattr()));
            return mapper.readTree((byte[])lookup.contentAs(0, byte[].class));
        }
        catch (DocumentNotFoundException | PathNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize checkpoint JSON", e);
        }
    }
}

